/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.AbstractSpringConfigurationTest;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;
import org.junit.Test;

public class RuleTranslationPluginTest
extends AbstractSpringConfigurationTest {
    private static final String LABEL = "label";
    private static final String USER = "root2";
    private static final String TITLE = "title";
    private final Identity adminAclIdentity = new Identity("root1", Arrays.asList(new MembershipEntry("/platform/administrators")));
    private TranslationService translationService;

    @Override
    public void setUp() {
        super.setUp();
        this.identityRegistry.register(this.adminAclIdentity);
        this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
    }

    @Test
    public void testManageTranslations() throws IllegalAccessException, ObjectNotFoundException {
        RuleDTO rule = this.newRuleDTO();
        Assert.assertNotNull((Object)rule);
        long ruleId = rule.getId();
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("rule", 5555L, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("rule", 0L, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, null, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("rule", ruleId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), null));
        this.translationService.saveTranslationLabels("rule", ruleId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), this.adminAclIdentity.getUserId());
        TranslationField translationField = this.translationService.getTranslationField("rule", ruleId, TITLE, this.adminAclIdentity.getUserId());
        Assert.assertNotNull((Object)translationField);
        Assert.assertEquals((long)ruleId, (long)translationField.getObjectId());
        Assert.assertEquals((Object)"rule", (Object)translationField.getObjectType());
        Assert.assertEquals(translationField.getLabels().get(Locale.ENGLISH), (Object)LABEL);
    }
}

