/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActionActivityChildPlugin
extends AbstractNotificationChildPlugin {
    private ActivityManager activityManager;
    private TranslationService translationService;
    private RuleService ruleService;

    public ActionActivityChildPlugin(ActivityManager activityManager, RuleService ruleService, TranslationService translationService, InitParams initParams) {
        super(initParams);
        this.activityManager = activityManager;
        this.translationService = translationService;
        this.ruleService = ruleService;
    }

    public String makeContent(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        if (notification == null) {
            return "";
        }
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(this.getId(), language);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || activity.isComment()) {
            return "";
        }
        String ruleId = this.getActivityParamValue(activity, "ruleId");
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return "";
        }
        RuleDTO rule = this.ruleService.findRuleById(Long.parseLong(ruleId));
        if (rule == null || rule.isDeleted() || rule.getProgram() == null || rule.getProgram().isDeleted()) {
            return null;
        }
        ProgramDTO program = rule.getProgram();
        Locale userLocale = LocaleUtils.toLocale((String)language);
        String ruleTitle = this.translationService.getTranslationLabel("rule", Long.parseLong(ruleId), "title", userLocale);
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            ruleTitle = rule.getTitle();
        }
        templateContext.put((Object)"PROGRAM_AVATAR", (Object)program.getAvatarUrl());
        templateContext.put((Object)"RULE_ID", (Object)String.valueOf(ruleId));
        templateContext.put((Object)"RULE_TITLE", (Object)ruleTitle);
        String ruleUrl = LinkProviderUtils.getRedirectUrl((String)"view_full_activity", (String)String.valueOf(rule.getActivityId()));
        templateContext.put((Object)"RULE_URL", (Object)ruleUrl);
        return TemplateUtils.processGroovy((TemplateContext)templateContext);
    }

    public String getId() {
        return "gamificationRuleActivity";
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    public String getActivityParamValue(ExoSocialActivity activity, String key) {
        Map params = activity.getTemplateParams();
        if (params != null) {
            return params.get(key) != null ? (String)params.get(key) : "";
        }
        return null;
    }
}

