/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.Period;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.StandardLeaderboard;
import io.meeds.gamification.model.filter.LeaderboardFilter;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.impl.RealizationServiceImpl;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RealizationServiceMockTest
extends AbstractServiceTest {
    private static final Random RANDOM = new Random();
    protected static final long MILLIS_IN_A_DAY = 86400000L;
    protected static final Date fromDate = new Date();
    protected static final Date toDate = new Date(fromDate.getTime() + 86400000L);
    protected static final int offset = 0;
    protected static final int limit = 3;
    private static MockedStatic<ExoContainerContext> CONTAINER_CONTEXT;
    @Mock
    IdentityManager identityManager;
    @Mock
    ProgramService programService;
    @Mock
    RuleService ruleService;
    @Mock
    EventService eventService;
    @Mock
    SpaceService spaceService;
    @Mock
    RealizationStorage realizationsStorage;
    @Mock
    IdentityRegistry identityRegistry;
    @Mock
    ListenerService listenerService;
    @Mock
    ResourceBundleService resourceBundleService;
    RealizationService realizationService;

    @BeforeClass
    public static void initClassContext() {
        CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    }

    @AfterClass
    public static void endClassContext() {
        CONTAINER_CONTEXT.close();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.realizationService = new RealizationServiceImpl(this.programService, this.ruleService, this.resourceBundleService, this.eventService, this.identityManager, this.spaceService, this.realizationsStorage, this.listenerService, null);
    }

    @Test
    public void testGetRealizationsByFilter() throws IllegalAccessException {
        RealizationFilter filter = new RealizationFilter();
        Identity userAclIdentity = new Identity("root1");
        org.exoplatform.social.core.identity.model.Identity adminIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)adminIdentity.getId()).thenReturn((Object)"2");
        Mockito.when((Object)adminIdentity.getRemoteId()).thenReturn((Object)userAclIdentity.getUserId());
        ConversationState.setCurrent((ConversationState)new ConversationState(userAclIdentity));
        ArrayList memberships = new ArrayList();
        userAclIdentity.setMemberships(memberships);
        CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IdentityRegistry.class)).thenReturn((Object)this.identityRegistry);
        Mockito.when((Object)this.identityRegistry.getIdentity(adminIdentity.getRemoteId())).thenReturn((Object)userAclIdentity);
        RealizationDTO gHistory1 = this.newRealizationDTO();
        RealizationDTO gHistory2 = this.newRealizationDTO();
        RealizationDTO gHistory3 = this.newRealizationDTO();
        ArrayList<RealizationDTO> realizations = new ArrayList<RealizationDTO>();
        realizations.add(gHistory1);
        realizations.add(gHistory2);
        realizations.add(gHistory3);
        Mockito.when((Object)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3)).thenReturn(realizations);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(userAclIdentity.getUserId())).thenReturn((Object)adminIdentity);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.getRealizationsByFilter(null, userAclIdentity, 0, 3));
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.getRealizationsByFilter(filter, null, 0, 3).size());
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setFromDate(fromDate);
        filter.setToDate(toDate);
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setOwned(true);
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setProgramIds(Collections.singletonList(5555L));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.getRealizationsByFilter(filter, userAclIdentity, 0, 3));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setOwned(false);
        filter.setProgramIds(Collections.singletonList(5555L));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.getRealizationsByFilter(filter, userAclIdentity, 0, 3));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setOwned(false);
        filter.setProgramIds(null);
        filter.setEarnerIds(Collections.singletonList(adminIdentity.getId()));
        List createdRealizations = this.realizationService.getRealizationsByFilter(filter, userAclIdentity, 0, 3);
        RealizationServiceMockTest.assertNotNull((Object)createdRealizations);
        RealizationServiceMockTest.assertEquals((int)3, (int)createdRealizations.size());
        userAclIdentity.setMemberships(Arrays.asList(new MembershipEntry("/platform/administrators")));
        filter.setFromDate(toDate);
        filter.setToDate(fromDate);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.getRealizationsByFilter(filter, userAclIdentity, 0, 3));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.countRealizationsByFilter(filter, userAclIdentity));
        filter.setFromDate(fromDate);
        filter.setToDate(toDate);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.countRealizationsByFilter(null, userAclIdentity));
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.countRealizationsByFilter(filter, null));
        filter.setEarnerIds(null);
        createdRealizations = this.realizationService.getRealizationsByFilter(filter, userAclIdentity, 0, 3);
        RealizationServiceMockTest.assertNotNull((Object)createdRealizations);
        RealizationServiceMockTest.assertEquals((int)3, (int)createdRealizations.size());
    }

    @Test
    public void updateRealizationStatus() throws Exception {
        RealizationDTO gHistory1 = this.newRealizationDTO();
        RealizationDTO gHistory2 = this.newRealizationDTO();
        gHistory2.setStatus(RealizationStatus.REJECTED.name());
        Mockito.when((Object)this.realizationsStorage.getRealizationById(gHistory1.getId().longValue())).thenReturn((Object)gHistory1);
        Mockito.when((Object)this.realizationsStorage.getRealizationById(gHistory2.getId().longValue())).thenReturn((Object)gHistory2);
        Mockito.when((Object)this.realizationsStorage.updateRealization(gHistory1)).thenReturn((Object)gHistory1);
        Mockito.when((Object)this.realizationsStorage.updateRealization(gHistory2)).thenReturn((Object)gHistory2);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), null));
        Assert.assertThrows(IllegalAccessException.class, () -> this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), RealizationStatus.ACCEPTED, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), null, "test"));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.realizationService.updateRealizationStatus(5000L, RealizationStatus.ACCEPTED));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.realizationService.updateRealizationStatus(5000L, RealizationStatus.ACCEPTED, "test"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), RealizationStatus.CANCELED, "root1"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), RealizationStatus.DELETED, "root1"));
        this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), RealizationStatus.REJECTED);
        RealizationServiceMockTest.assertEquals((String)RealizationStatus.REJECTED.name(), (String)this.realizationService.getRealizationById(gHistory1.getId().longValue()).getStatus());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)Mockito.eq((Object)"realization.canceled"), Mockito.any(), Mockito.any());
        this.realizationService.updateRealizationStatus(gHistory2.getId().longValue(), RealizationStatus.ACCEPTED);
        RealizationServiceMockTest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)this.realizationService.getRealizationById(gHistory2.getId().longValue()).getStatus());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)Mockito.eq((Object)"realization.updated"), Mockito.any(), Mockito.any());
        this.realizationService.updateRealizationStatus(gHistory1.getId().longValue(), RealizationStatus.REJECTED, "root1");
        RealizationServiceMockTest.assertEquals((String)RealizationStatus.REJECTED.name(), (String)this.realizationService.getRealizationById(gHistory1.getId().longValue()).getStatus());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)2))).broadcast((String)Mockito.eq((Object)"realization.canceled"), Mockito.any(), Mockito.any());
        this.realizationService.updateRealizationStatus(gHistory2.getId().longValue(), RealizationStatus.ACCEPTED, "root1");
        RealizationServiceMockTest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)this.realizationService.getRealizationById(gHistory2.getId().longValue()).getStatus());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)2))).broadcast((String)Mockito.eq((Object)"realization.updated"), Mockito.any(), Mockito.any());
    }

    public void testBuildHistory() throws Exception {
        RuleDTO ruleDTO = this.newRuleDTO();
        List realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "11", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)realizations));
        ProgramDTO program = this.newProgram();
        program.setDeleted(true);
        ruleDTO.setProgram(program);
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)realizations));
        ruleDTO = this.newRuleDTO();
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)realizations));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)Mockito.eq((Object)"realization.created"), Mockito.any(), Mockito.any());
    }

    public void testCreateRealizations() {
        List realizationEntities = this.realizationDAO.findAll();
        RealizationServiceMockTest.assertEquals((int)realizationEntities.size(), (int)0);
        RuleDTO ruleDTO = this.newRuleDTO();
        List realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)realizations));
        realizationEntities = this.realizationDAO.findAll();
        RealizationServiceMockTest.assertEquals((int)realizationEntities.size(), (int)1);
        RealizationEntity realizationEntity = (RealizationEntity)realizationEntities.get(0);
        RealizationServiceMockTest.assertEquals((Object)"1", (Object)realizationEntity.getEarnerId());
        RealizationServiceMockTest.assertEquals((String)"10", (String)realizationEntity.getReceiver());
        RealizationServiceMockTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceMockTest.assertEquals((Object)IdentityType.USER, (Object)realizationEntity.getEarnerType());
        realizations = this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)realizations));
        realizationEntities = this.realizationDAO.findAll();
        RealizationServiceMockTest.assertEquals((int)realizationEntities.size(), (int)2);
        realizationEntity = (RealizationEntity)realizationEntities.get(1);
        RealizationServiceMockTest.assertEquals((Object)"150", (Object)realizationEntity.getEarnerId());
        RealizationServiceMockTest.assertEquals((String)"10", (String)realizationEntity.getReceiver());
        RealizationServiceMockTest.assertEquals((String)"245590", (String)realizationEntity.getObjectId());
        RealizationServiceMockTest.assertEquals((Object)IdentityType.SPACE, (Object)realizationEntity.getEarnerType());
    }

    public void testLeaderboardRank() {
        ProgramDTO program = this.newProgram();
        RuleDTO ruleDTO = this.newRuleDTO("createNewTask", program.getId());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "10", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "152", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "152", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "152", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "152", "10", "245590", "activity");
        Date date = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
        int rankUser1 = this.realizationService.getLeaderboardRank(Long.parseLong("1"), date, null, null, Long.valueOf(program.getId()));
        int rankUser2 = this.realizationService.getLeaderboardRank(Long.parseLong("10"), date, null, null, Long.valueOf(program.getId()));
        RealizationServiceMockTest.assertEquals((int)1, (int)rankUser1);
        RealizationServiceMockTest.assertEquals((int)2, (int)rankUser2);
        int rankSpace2 = this.realizationService.getLeaderboardRank(Long.parseLong("152"), date, null, null, Long.valueOf(program.getId()));
        int rankSpace1 = this.realizationService.getLeaderboardRank(Long.parseLong("150"), date, null, null, Long.valueOf(program.getId()));
        RealizationServiceMockTest.assertEquals((int)1, (int)rankSpace2);
        RealizationServiceMockTest.assertEquals((int)2, (int)rankSpace1);
        rankUser1 = this.realizationService.getLeaderboardRank(Long.parseLong("1"), date, null, Long.valueOf(program.getSpaceId()), null);
        rankUser2 = this.realizationService.getLeaderboardRank(Long.parseLong("10"), date, null, Long.valueOf(program.getSpaceId()), null);
        RealizationServiceMockTest.assertEquals((int)1, (int)rankUser1);
        RealizationServiceMockTest.assertEquals((int)2, (int)rankUser2);
    }

    public void testFindUserReputationBySocialId() {
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationServiceMockTest.assertEquals((long)this.realizationService.getScoreByIdentityId("1"), (long)0L);
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "150", "10", "245590", "activity");
        RealizationServiceMockTest.assertTrue((this.realizationService.getScoreByIdentityId("1") > 0L ? 1 : 0) != 0);
        RealizationServiceMockTest.assertTrue((this.realizationService.getScoreByIdentityId("150") > 0L ? 1 : 0) != 0);
    }

    public void testBuildDomainScoreByUserId() {
        RuleDTO ruleDTO = this.newRuleDTO();
        RealizationServiceMockTest.assertEquals((int)0, (int)this.realizationService.getScorePerProgramByIdentityId("1").size());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        RealizationServiceMockTest.assertEquals((int)1, (int)this.realizationService.getScorePerProgramByIdentityId("1").size());
    }

    public void testFilterByDomainId() throws IllegalAccessException {
        RuleDTO ruleDTO = this.newRuleDTO();
        LeaderboardFilter filter = new LeaderboardFilter();
        filter.setPeriod(Period.ALL.name());
        filter.setIdentityType(IdentityType.USER);
        filter.setLimit(3);
        filter.setProgramId(Long.valueOf(ruleDTO.getProgram().getId()));
        List filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceMockTest.assertEquals((int)0, (int)filteredLeaderboard.size());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceMockTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        StandardLeaderboard userLeaderboard = (StandardLeaderboard)filteredLeaderboard.get(0);
        RealizationServiceMockTest.assertEquals((String)"1", (String)userLeaderboard.getEarnerId());
        RealizationServiceMockTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setPeriod(Period.WEEK.name());
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceMockTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        userLeaderboard = (StandardLeaderboard)filteredLeaderboard.get(0);
        RealizationServiceMockTest.assertEquals((String)"1", (String)userLeaderboard.getEarnerId());
        RealizationServiceMockTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setPeriod(Period.MONTH.name());
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceMockTest.assertEquals((int)1, (int)filteredLeaderboard.size());
        userLeaderboard = (StandardLeaderboard)filteredLeaderboard.get(0);
        RealizationServiceMockTest.assertEquals((String)"1", (String)userLeaderboard.getEarnerId());
        RealizationServiceMockTest.assertEquals((long)ruleDTO.getScore(), (long)userLeaderboard.getReputationScore());
        filter.setIdentityType(IdentityType.SPACE);
        filteredLeaderboard = this.realizationService.getLeaderboard(filter, null);
        RealizationServiceMockTest.assertEquals((int)0, (int)filteredLeaderboard.size());
    }

    public void testDeleteHistory() {
        ProgramDTO program = this.newProgram();
        RuleDTO ruleDTO = this.newRuleDTO("createNewTask", program.getId());
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "1", "10", "245590", "activity");
        this.realizationService.createRealizations(ruleDTO.getEvent().getTitle(), null, "10", "1", "245590", "activity");
        RealizationFilter identityFilter = new RealizationFilter();
        identityFilter.setEarnerIds(Collections.singletonList("1"));
        List realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceMockTest.assertNotNull((Object)realizations);
        RealizationServiceMockTest.assertEquals((int)1, (int)realizations.size());
        RealizationDTO lastRealization = (RealizationDTO)realizations.get(0);
        RealizationServiceMockTest.assertEquals((Object)RealizationStatus.ACCEPTED, (Object)lastRealization.getStatus());
        identityFilter.setEarnerIds(Collections.singletonList("10"));
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceMockTest.assertNotNull((Object)realizations);
        RealizationServiceMockTest.assertEquals((int)1, (int)realizations.size());
        lastRealization = (RealizationDTO)realizations.get(0);
        RealizationServiceMockTest.assertEquals((Object)RealizationStatus.ACCEPTED, (Object)lastRealization.getStatus());
        this.realizationService.deleteRealizations("245590", "activity");
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceMockTest.assertNotNull((Object)realizations);
        RealizationServiceMockTest.assertEquals((int)1, (int)realizations.size());
        lastRealization = (RealizationDTO)realizations.get(0);
        RealizationServiceMockTest.assertEquals((Object)RealizationStatus.DELETED, (Object)lastRealization.getStatus());
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RealizationServiceMockTest.assertNotNull((Object)realizations);
        RealizationServiceMockTest.assertEquals((int)1, (int)realizations.size());
        lastRealization = (RealizationDTO)realizations.get(0);
        RealizationServiceMockTest.assertEquals((Object)RealizationStatus.DELETED, (Object)lastRealization.getStatus());
    }

    @Override
    protected RealizationDTO newRealizationDTO() {
        RealizationDTO gHistory = new RealizationDTO();
        gHistory.setId(Long.valueOf(RANDOM.nextLong(1L, 10000L)));
        gHistory.setStatus(RealizationStatus.ACCEPTED.name());
        gHistory.setProgram(new ProgramDTO());
        gHistory.setReceiver("1");
        gHistory.setEarnerId("1L");
        gHistory.setEarnerType(IdentityType.USER.name());
        gHistory.setActionTitle("gamification title");
        gHistory.setActionScore(10L);
        gHistory.setGlobalScore(10L);
        gHistory.setRuleId(Long.valueOf(1L));
        gHistory.setCreatedDate(Utils.toRFC3339Date((Date)fromDate));
        return gHistory;
    }
}

