/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActionAnnouncedNotificationPlugin
extends BaseNotificationPlugin {
    private final RuleService ruleService;
    private final ActivityManager activityManager;
    private final SpaceService spaceService;

    public ActionAnnouncedNotificationPlugin(RuleService ruleService, ActivityManager activityManager, InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.ruleService = ruleService;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
    }

    public String getId() {
        return "GamificationActionAnnouncedNotification";
    }

    public boolean isValid(NotificationContext ctx) {
        Announcement announcement = (Announcement)ctx.value(Utils.ANNOUNCEMENT_NOTIFICATION_PARAMETER);
        return announcement != null && announcement.getCreator() != null && announcement.getCreator() > 0L && announcement.getActivityId() > 0L;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        Announcement announcement = (Announcement)ctx.value(Utils.ANNOUNCEMENT_NOTIFICATION_PARAMETER);
        if (announcement == null) {
            return null;
        }
        RuleDTO rule = this.ruleService.findRuleById(announcement.getChallengeId());
        if (rule == null) {
            return null;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(rule.getActivityId()));
        if (activity == null) {
            return null;
        }
        List<Object> targetUsers = new ArrayList();
        Space space = this.spaceService.getSpaceById(String.valueOf(rule.getSpaceId()));
        if (space != null) {
            targetUsers = Arrays.stream(space.getManagers()).filter(targetUser -> !Objects.equals(Utils.getUserRemoteId(String.valueOf(announcement.getCreator())), targetUser)).toList();
        }
        HashSet finalTargetUsers = new HashSet(targetUsers);
        ProgramDTO programDTO = rule.getProgram();
        programDTO.getOwnerIds().forEach(userId -> {
            String userRemoteId = Utils.getUserRemoteId(String.valueOf(userId));
            finalTargetUsers.add(userRemoteId);
        });
        if (targetUsers.isEmpty()) {
            return null;
        }
        return NotificationInfo.instance().to(new ArrayList(finalTargetUsers)).setSpaceId(rule.getSpaceId()).with("RULE_ID", String.valueOf(announcement.getChallengeId())).with("ANNOUNCEMENT_ID", String.valueOf(announcement.getId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), String.valueOf(announcement.getActivityId())).key(this.getId()).end();
    }
}

