/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.dao.EventDAO;
import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import io.meeds.gamification.storage.mapper.RuleMapper;
import io.meeds.kernel.test.AbstractSpringTest;
import java.util.Date;
import java.util.HashSet;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootApplication(scanBasePackages={"io.meeds.gamification", "io.meeds.social.common", "io.meeds.social.cms", "io.meeds.social.html", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa"}, exclude={LiquibaseAutoConfiguration.class})
@PropertySources(value={@PropertySource(value={"classpath:application.properties"}), @PropertySource(value={"classpath:application-common.properties"})})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/gamification-test-configuration.xml")})
@EnableAutoConfiguration(exclude={LiquibaseAutoConfiguration.class})
@RunWith(value=SpringRunner.class)
public abstract class AbstractSpringConfigurationTest
extends AbstractSpringTest {
    private static final String GAMIFICATION_DOMAIN = "TeamWork";
    private static final String RULE_NAME = "createNewTask";
    private static final String TEST_USER_EARNER = "1";
    private static final String TEST_SCORE = "50";
    private static final String DESCRIPTION = "Description";
    protected ProgramStorage programStorage;
    protected EventStorage eventStorage;
    protected RuleStorage ruleStorage;
    protected ProgramDAO programDAO;
    protected RuleDAO ruleDAO;
    protected EventDAO eventDAO;
    protected IdentityRegistry identityRegistry;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;

    protected AbstractSpringConfigurationTest() {
        AbstractSpringTest.setTestClass(AbstractSpringConfigurationTest.class);
    }

    @Before
    public void setUp() {
        this.begin();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.programStorage = (ProgramStorage)this.getContainer().getComponentInstanceOfType(ProgramStorage.class);
        this.eventStorage = (EventStorage)this.getContainer().getComponentInstanceOfType(EventStorage.class);
        this.ruleStorage = (RuleStorage)this.getContainer().getComponentInstanceOfType(RuleStorage.class);
        this.programDAO = (ProgramDAO)this.getContainer().getComponentInstanceOfType(ProgramDAO.class);
        this.ruleDAO = (RuleDAO)this.getContainer().getComponentInstanceOfType(RuleDAO.class);
        this.eventDAO = (EventDAO)this.getContainer().getComponentInstanceOfType(EventDAO.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
    }

    @After
    public void tearDown() {
        this.end();
    }

    protected RuleDTO newRuleDTO() {
        return RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)this.newRule());
    }

    protected ProgramDTO newProgram() {
        return ProgramMapper.fromEntity((RuleDAO)this.ruleDAO, (ProgramEntity)this.newDomain());
    }

    protected ProgramEntity newDomain() {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(GAMIFICATION_DOMAIN);
        domain.setDescription(DESCRIPTION);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(new Date());
        domain.setType(EntityType.AUTOMATIC);
        domain.setCreatedDate(new Date());
        domain.setAudienceId(Long.valueOf(1L));
        HashSet<Long> owners = new HashSet<Long>();
        owners.add(1L);
        domain.setOwners(owners);
        domain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        return domain;
    }

    protected ProgramEntity newDomain(String name) {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(name);
        domain.setDescription(name);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(new Date());
        domain.setType(EntityType.AUTOMATIC);
        domain.setCreatedDate(new Date());
        domain.setAudienceId(Long.valueOf(1L));
        domain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        this.restartTransaction();
        return domain;
    }

    protected RuleEntity newRule() {
        RuleEntity rule = this.ruleDAO.findRuleByTitle(GAMIFICATION_DOMAIN);
        if (rule == null) {
            rule = new RuleEntity();
            rule.setScore(Integer.parseInt(TEST_SCORE));
            rule.setTitle(RULE_NAME);
            rule.setDescription(DESCRIPTION);
            rule.setEnabled(true);
            rule.setDeleted(false);
            rule.setEventEntity(this.newEvent(RULE_NAME));
            rule.setCreatedBy(TEST_USER_EARNER);
            rule.setCreatedDate(new Date());
            rule.setLastModifiedBy(TEST_USER_EARNER);
            rule.setLastModifiedDate(new Date());
            rule.setDomainEntity(this.newDomain());
            rule.setType(EntityType.AUTOMATIC);
            rule.setDefaultRealizationStatus(RealizationStatus.ACCEPTED);
            rule.setRecurrence(RecurrenceType.NONE);
            rule = (RuleEntity)this.ruleDAO.create((Object)rule);
        }
        return rule;
    }

    protected EventEntity newEvent(String name) {
        EventEntity event = new EventEntity();
        event.setTitle(name);
        event.setTrigger(name);
        event.setType("eventType");
        event = (EventEntity)this.eventDAO.create((Object)event);
        return event;
    }
}

