/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.AbstractSpringConfigurationTest;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProgramTranslationPluginTest
extends AbstractSpringConfigurationTest {
    private static final String USER = "root2";
    private static final String LABEL = "label";
    private static final String TITLE = "title";
    private final Identity adminAclIdentity = new Identity("root1", Arrays.asList(new MembershipEntry("/platform/administrators")));
    private TranslationService translationService;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.identityRegistry.register(this.adminAclIdentity);
        this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
    }

    @Test
    public void testManageTranslations() throws IllegalAccessException, ObjectNotFoundException {
        ProgramDTO program = this.newProgram();
        Assert.assertNotNull((Object)program);
        long programId = program.getId();
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("program", programId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("program", 5555L, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), this.adminAclIdentity.getUserId()));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("program", 0L, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("program", programId, null, Collections.singletonMap(Locale.ENGLISH, LABEL), USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("program", programId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), null));
        this.translationService.saveTranslationLabels("program", programId, TITLE, Collections.singletonMap(Locale.ENGLISH, LABEL), this.adminAclIdentity.getUserId());
        TranslationField translationField = this.translationService.getTranslationField("program", programId, TITLE, this.adminAclIdentity.getUserId());
        Assert.assertNotNull((Object)translationField);
        Assert.assertEquals((Object)String.valueOf(programId), (Object)translationField.getObjectId());
        Assert.assertEquals((Object)"program", (Object)translationField.getObjectType());
        Assert.assertEquals(translationField.getLabels().get(Locale.ENGLISH), (Object)LABEL);
    }
}

