/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.GamificationActivityListener;
import io.meeds.gamification.service.RuleService;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GamificationActivityListenerTest {
    @Mock
    private RuleService ruleService;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private ListenerService listenerService;

    @Test
    public void testActivityPin() throws Exception {
        InitParams params = (InitParams)Mockito.mock(InitParams.class);
        Mockito.when((Object)params.containsKey((Object)"exclude.commentTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.commentTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        Mockito.when((Object)params.containsKey((Object)"exclude.activityTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.activityTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        GamificationActivityListener gamificationActivityListener = new GamificationActivityListener(this.ruleService, this.identityManager, this.activityManager, this.spaceService, this.listenerService, params);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)"5");
        ActivityLifeCycleEvent event = new ActivityLifeCycleEvent(null, activity, "1");
        gamificationActivityListener.pinActivity(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("pinActivityOnSpace"))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testActivityComment() throws Exception {
        InitParams params = (InitParams)Mockito.mock(InitParams.class);
        Mockito.when((Object)params.containsKey((Object)"exclude.commentTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.commentTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        Mockito.when((Object)params.containsKey((Object)"exclude.activityTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.activityTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        GamificationActivityListener gamificationActivityListener = new GamificationActivityListener(this.ruleService, this.identityManager, this.activityManager, this.spaceService, this.listenerService, params);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        ExoSocialActivity parent = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)this.activityManager.getParentActivity(activity)).thenReturn((Object)parent);
        ActivityLifeCycleEvent event = new ActivityLifeCycleEvent(null, activity, "1");
        gamificationActivityListener.saveComment(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("receiveCommentOnActivity"))), ArgumentMatchers.eq(null));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("postActivityComment"))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testActivityCommentWithExcludedType() throws Exception {
        InitParams params = (InitParams)Mockito.mock(InitParams.class);
        ValuesParam values = (ValuesParam)Mockito.mock(ValuesParam.class);
        Mockito.when((Object)params.containsKey((Object)"exclude.commentTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.commentTypes")).thenReturn((Object)values);
        String excludedCommentType = "testCommentType";
        Mockito.when((Object)values.getValues()).thenReturn(Collections.singletonList(excludedCommentType));
        Mockito.when((Object)params.containsKey((Object)"exclude.activityTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.activityTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        GamificationActivityListener gamificationActivityListener = new GamificationActivityListener(this.ruleService, this.identityManager, this.activityManager, this.spaceService, this.listenerService, params);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        ExoSocialActivity parent = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)activity.getType()).thenReturn((Object)excludedCommentType);
        Mockito.when((Object)this.activityManager.getParentActivity(activity)).thenReturn((Object)parent);
        ActivityLifeCycleEvent event = new ActivityLifeCycleEvent(null, activity, "1");
        gamificationActivityListener.saveComment(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("receiveCommentOnActivity"))), ArgumentMatchers.eq(null));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("postActivityComment"))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testActivityWithExcludedType() throws Exception {
        InitParams params = (InitParams)Mockito.mock(InitParams.class);
        ValuesParam values = (ValuesParam)Mockito.mock(ValuesParam.class);
        String excludedActivityType = "testActivityType";
        Mockito.when((Object)values.getValues()).thenReturn(Collections.singletonList(excludedActivityType));
        Mockito.when((Object)params.containsKey((Object)"exclude.activityTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.activityTypes")).thenReturn((Object)values);
        Mockito.when((Object)params.containsKey((Object)"exclude.commentTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.commentTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        GamificationActivityListener gamificationActivityListener = new GamificationActivityListener(this.ruleService, this.identityManager, this.activityManager, this.spaceService, this.listenerService, params);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)activity.getType()).thenReturn((Object)excludedActivityType);
        ActivityLifeCycleEvent event = new ActivityLifeCycleEvent(null, activity, "1");
        gamificationActivityListener.saveActivity(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("postActivity"))), ArgumentMatchers.eq(null));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("receiveActivity"))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testHiddenActivity() throws Exception {
        InitParams params = (InitParams)Mockito.mock(InitParams.class);
        Mockito.when((Object)params.containsKey((Object)"exclude.activityTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.activityTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        Mockito.when((Object)params.containsKey((Object)"exclude.commentTypes")).thenReturn((Object)true);
        Mockito.when((Object)params.getValuesParam("exclude.commentTypes")).thenReturn((Object)((ValuesParam)Mockito.mock(ValuesParam.class)));
        GamificationActivityListener gamificationActivityListener = new GamificationActivityListener(this.ruleService, this.identityManager, this.activityManager, this.spaceService, this.listenerService, params);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)true);
        ActivityLifeCycleEvent event = new ActivityLifeCycleEvent(null, activity, "1");
        gamificationActivityListener.saveActivity(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("postActivity"))), ArgumentMatchers.eq(null));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("receiveActivity"))), ArgumentMatchers.eq(null));
    }
}

