/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ConnectorSettingServiceTest
extends AbstractServiceTest {
    private static final String ADMIN_USER = "root1";
    private static final String INTERNAL_USER = "internalUser";
    private Identity adminAclIdentity;
    private Identity internalIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminAclIdentity = this.registerAdministratorUser(ADMIN_USER);
        this.internalIdentity = this.registerInternalUser(INTERNAL_USER);
    }

    @Test
    public void testSaveConnectorSettings() throws Exception {
        RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings("connectorName", this.adminAclIdentity);
        remoteConnectorSettings.setName("connectorName");
        remoteConnectorSettings.setApiKey("12345apiKey");
        remoteConnectorSettings.setSecretKey("12345SecretKey");
        remoteConnectorSettings.setRedirectUrl("http://localhost:8080");
        remoteConnectorSettings.setEnabled(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings, this.internalIdentity));
        this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings, this.adminAclIdentity);
        RemoteConnectorSettings storedRemoteConnectorSettings = this.connectorSettingService.getConnectorSettings("connectorName", this.adminAclIdentity);
        String storedSecretKet = this.connectorSettingService.getConnectorSecretKey(remoteConnectorSettings.getName());
        String decryptedSecretKey = this.codecInitializer.getCodec().decode(remoteConnectorSettings.getSecretKey());
        ConnectorSettingServiceTest.assertEquals((String)remoteConnectorSettings.getName(), (String)storedRemoteConnectorSettings.getName());
        ConnectorSettingServiceTest.assertEquals((String)remoteConnectorSettings.getApiKey(), (String)storedRemoteConnectorSettings.getApiKey());
        ConnectorSettingServiceTest.assertEquals((String)decryptedSecretKey, (String)storedSecretKet);
        ConnectorSettingServiceTest.assertEquals((String)remoteConnectorSettings.getRedirectUrl(), (String)storedRemoteConnectorSettings.getRedirectUrl());
        ConnectorSettingServiceTest.assertEquals((boolean)remoteConnectorSettings.isEnabled(), (boolean)storedRemoteConnectorSettings.isEnabled());
    }

    @Test
    public void testGetConnectorsSettings() throws Exception {
        RemoteConnectorSettings remoteConnectorSettings1 = this.connectorSettingService.getConnectorSettings("connectorName1", this.adminAclIdentity);
        remoteConnectorSettings1.setName("connectorName1");
        remoteConnectorSettings1.setApiKey("12345Name1");
        remoteConnectorSettings1.setSecretKey("12345Name1");
        remoteConnectorSettings1.setRedirectUrl("http://localhost:8080");
        remoteConnectorSettings1.setEnabled(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.connectorSettingService.getConnectorSettings("connectorName2", this.internalIdentity));
        RemoteConnectorSettings remoteConnectorSettings2 = this.connectorSettingService.getConnectorSettings("connectorName2", this.adminAclIdentity);
        remoteConnectorSettings2.setName("connectorName2");
        remoteConnectorSettings2.setApiKey("12345Name2");
        remoteConnectorSettings2.setSecretKey("12345Name2");
        remoteConnectorSettings2.setRedirectUrl("http://localhost:8080");
        remoteConnectorSettings2.setEnabled(true);
        this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings1, this.adminAclIdentity);
        this.connectorSettingService.saveConnectorSettings(remoteConnectorSettings2, this.adminAclIdentity);
        ConnectorPlugin connectorPlugin1 = (ConnectorPlugin)Mockito.mock(ConnectorPlugin.class);
        Mockito.when((Object)connectorPlugin1.getConnectorName()).thenReturn((Object)"connectorName1");
        ConnectorPlugin connectorPlugin2 = (ConnectorPlugin)Mockito.mock(ConnectorPlugin.class);
        Mockito.when((Object)connectorPlugin2.getConnectorName()).thenReturn((Object)"connectorName2");
        ArrayList<ConnectorPlugin> connectorsPlugins = new ArrayList<ConnectorPlugin>();
        connectorsPlugins.add(connectorPlugin1);
        connectorsPlugins.add(connectorPlugin2);
        ConnectorService connectorService = (ConnectorService)Mockito.mock(ConnectorService.class);
        Mockito.when((Object)connectorService.getConnectorPlugins()).thenReturn(connectorsPlugins);
        Assert.assertThrows(IllegalAccessException.class, () -> this.connectorSettingService.getConnectorsSettings(connectorService, this.internalIdentity));
        List remoteConnectorSettingsList = this.connectorSettingService.getConnectorsSettings(connectorService, this.adminAclIdentity);
        String storedSecretKet = this.connectorSettingService.getConnectorSecretKey(remoteConnectorSettings2.getName());
        ConnectorSettingServiceTest.assertEquals((int)2, (int)remoteConnectorSettingsList.size());
        RemoteConnectorSettings storedRemoteConnectorSettings2 = remoteConnectorSettingsList.stream().filter(item -> item.getName().equals("connectorName2")).findFirst().orElse(null);
        String decryptedSecretKey = this.codecInitializer.getCodec().decode(remoteConnectorSettings2.getSecretKey());
        ConnectorSettingServiceTest.assertEquals((String)remoteConnectorSettings2.getApiKey(), (String)storedRemoteConnectorSettings2.getApiKey());
        ConnectorSettingServiceTest.assertEquals((String)decryptedSecretKey, (String)storedSecretKet);
        this.connectorSettingService.deleteConnectorSettings("connectorName2", this.adminAclIdentity);
        remoteConnectorSettingsList = this.connectorSettingService.getConnectorsSettings(connectorService, this.adminAclIdentity);
        storedSecretKet = this.connectorSettingService.getConnectorSecretKey(remoteConnectorSettings2.getName());
        ConnectorSettingServiceTest.assertEquals((int)2, (int)remoteConnectorSettingsList.size());
        storedRemoteConnectorSettings2 = remoteConnectorSettingsList.stream().filter(item -> item.getName().equals("connectorName2")).findFirst().orElse(null);
        ConnectorSettingServiceTest.assertNull((Object)storedRemoteConnectorSettings2.getApiKey());
        ConnectorSettingServiceTest.assertNull((Object)storedSecretKet);
    }
}

