/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.filter.EventFilter;
import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.storage.mapper.EventMapper;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class EventServiceTest
extends AbstractServiceTest {
    private static final String ADMIN_USER = "root1";
    private static final String EVENT_NAME = "eventName";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.registerAdministratorUser(ADMIN_USER);
    }

    public void testCreateEvent() throws Exception {
        EventFilter eventFilter = new EventFilter();
        EventServiceTest.assertEquals(Collections.emptyList(), (Object)this.eventService.getEvents(eventFilter, 0, 3));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.eventService.createEvent(null));
        EventEntity eventEntity = new EventEntity();
        eventEntity.setType("connectorName");
        eventEntity.setTitle("event1");
        eventEntity.setTrigger("trigger1");
        this.eventService.createEvent(EventMapper.fromEntity((EventEntity)eventEntity));
        EventServiceTest.assertNotNull((Object)this.eventService.getEvents(eventFilter, 0, 3));
        EventServiceTest.assertEquals((int)1, (int)this.eventService.countEvents(eventFilter));
    }

    public void testDeleteEvent() throws Exception {
        EventFilter eventFilter = new EventFilter();
        EventServiceTest.assertEquals(Collections.emptyList(), (Object)this.eventService.getEvents(eventFilter, 0, 3));
        EventEntity eventEntity = new EventEntity();
        eventEntity.setType("connectorName");
        eventEntity.setTitle("event1");
        eventEntity.setTrigger("trigger1");
        EventDTO eventDTO = this.eventService.createEvent(EventMapper.fromEntity((EventEntity)eventEntity));
        EventServiceTest.assertNotNull((Object)this.eventService.getEvents(eventFilter, 0, 3));
        this.eventService.deleteEventById(eventDTO.getId());
        EventServiceTest.assertEquals(Collections.emptyList(), (Object)this.eventService.getEvents(eventFilter, 0, 3));
    }

    public void testUpdateEvent() throws Exception {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setType("connectorName");
        eventEntity.setTitle("event1");
        eventEntity.setTrigger("trigger1");
        EventDTO eventDTO = this.eventService.createEvent(EventMapper.fromEntity((EventEntity)eventEntity));
        EventServiceTest.assertNotNull((Object)this.eventService.getEventByTitleAndTrigger("event1", "trigger1"));
        EventServiceTest.assertEquals((String)"trigger1", (String)this.eventService.getEvent(eventDTO.getId()).getTrigger());
        eventDTO.setTrigger("trigger2");
        this.eventService.updateEvent(eventDTO);
        EventServiceTest.assertEquals((String)"trigger2", (String)this.eventService.getEvent(eventDTO.getId()).getTrigger());
    }

    public void testEventPlugin() {
        this.setEventPlugin();
        EventServiceTest.assertEquals(List.of("trigger1", "trigger2", "trigger3"), (Object)this.eventService.getEventPlugin("trigger1").getTriggers());
        EventServiceTest.assertFalse((boolean)this.eventService.getEventPlugin("trigger1").isValidEvent(new HashMap(), ""));
    }

    private void removeEventPlugin() {
        this.eventService.removePlugin(EVENT_NAME);
    }

    private void setEventPlugin() {
        this.removeEventPlugin();
        EventPlugin eventPlugin = new EventPlugin(this){

            public String getEventType() {
                return EventServiceTest.EVENT_NAME;
            }

            public List<String> getTriggers() {
                return List.of("trigger1", "trigger2", "trigger3");
            }

            public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
                return false;
            }
        };
        eventPlugin.setName(EVENT_NAME);
        this.eventService.addPlugin(eventPlugin);
    }
}

