/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.plugin.RuleActivityTypePlugin;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleActivityTypePluginTest {
    @Mock
    private ActivityStorage storage;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private UserACL userAclService;
    @Mock
    private ProgramService programService;
    @Mock
    private RuleService ruleService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private RelationshipManager relationshipManager;
    @Mock
    private RuleDTO rule;
    private long ruleId = 25L;
    private long activityId = 35L;

    @Test
    public void testActivityTypePlugin() {
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getType()).thenReturn((Object)"gamificationRuleActivity");
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)activity.getMetadataObjectId()).thenReturn((Object)String.valueOf(this.ruleId));
        Mockito.when((Object)activity.getId()).thenReturn((Object)String.valueOf(this.activityId));
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity viewer = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)viewer.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        Mockito.when((Object)this.ruleService.findRuleById(this.ruleId)).thenReturn((Object)this.rule);
        Mockito.when((Object)this.rule.getProgramId()).thenReturn((Object)2L);
        Mockito.when((Object)this.rule.getActivityId()).thenReturn((Object)this.activityId);
        ActivityManagerImpl activityManager = new ActivityManagerImpl(this.storage, this.identityManager, this.spaceService, this.relationshipManager, this.userAclService, null);
        Assert.assertTrue((boolean)activityManager.isActivityViewable(activity, owner));
        Assert.assertFalse((boolean)activityManager.isActivityViewable(activity, viewer));
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("type");
        valueParam.setValue("gamificationRuleActivity");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("enableNotification");
        valueParam.setValue("false");
        initParams.addParameter((Parameter)valueParam);
        activityManager.addActivityTypePlugin((ActivityTypePlugin)new RuleActivityTypePlugin(this.programService, this.ruleService, initParams));
        Mockito.when((Object)this.programService.canViewProgram(this.rule.getProgramId(), owner.getUserId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)activityManager.isActivityViewable(activity, owner));
        Assert.assertFalse((boolean)activityManager.isActivityViewable(activity, viewer));
        Mockito.when((Object)this.programService.canViewProgram(this.rule.getProgramId(), viewer.getUserId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)activityManager.isActivityViewable(activity, viewer));
    }
}

