/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.plugin.RuleContentLinkPlugin;
import io.meeds.gamification.service.RuleService;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.service.ContentLinkPluginService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleContentLinkPluginTest {
    private static final String RULE_TITLE = "ruleTitle";
    private static final Long RULE_ID = 55L;
    private static final String TEST_USER = "testUser";
    private static final String QUERY = "query";
    @Mock
    private ContentLinkPluginService contentLinkPluginService;
    @Mock
    private RuleService ruleService;
    @Mock
    private UserACL userAcl;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private TranslationService translationService;
    @Mock
    private Identity identity;
    @Mock
    private RuleDTO rule;
    @InjectMocks
    private RuleContentLinkPlugin plugin;

    @Test
    public void getExtension() {
        ContentLinkExtension extension = this.plugin.getExtension();
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((Object)"rule", (Object)extension.getObjectType());
        Assert.assertEquals((Object)"action", (Object)extension.getCommand());
        Assert.assertEquals((Object)"fa fa-trophy", (Object)extension.getIcon());
        Assert.assertEquals((Object)"contentLink.action", (Object)extension.getTitleKey());
    }

    @Test
    public void searchWhenEmpty() {
        Mockito.when((Object)this.userAcl.isAnonymousUser((Identity)null)).thenReturn((Object)true);
        List results = this.plugin.search(QUERY, null, null, 0, 10);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void searchWithQuery() {
        RuleFilter filter = new RuleFilter();
        filter.setTerm(QUERY);
        filter.setIdentityId(2L);
        filter.setLocale(Locale.ENGLISH);
        filter.setDateFilterType(DateFilterType.ALL);
        filter.setProgramStatus(EntityStatusType.ENABLED);
        filter.setStatus(EntityStatusType.ENABLED);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)TEST_USER);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(TEST_USER)).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)"2");
        Mockito.when((Object)this.rule.getId()).thenReturn((Object)RULE_ID);
        Mockito.when((Object)this.rule.getTitle()).thenReturn((Object)RULE_TITLE);
        List results = this.plugin.search(QUERY, this.identity, Locale.ENGLISH, 2, 10);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((boolean)results.isEmpty());
        Mockito.when((Object)this.ruleService.getRules(filter, 2, 10)).thenReturn(Collections.singletonList(this.rule));
        results = this.plugin.search(QUERY, this.identity, Locale.ENGLISH, 2, 10);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        ContentLinkSearchResult contentLinkSearchResult = (ContentLinkSearchResult)results.get(0);
        Assert.assertEquals((Object)this.plugin.getExtension().getObjectType(), (Object)contentLinkSearchResult.getObjectType());
        Assert.assertEquals((Object)String.valueOf(this.rule.getId()), (Object)contentLinkSearchResult.getObjectId());
        Assert.assertEquals((Object)this.plugin.getExtension().getIcon(), (Object)contentLinkSearchResult.getIcon());
        Assert.assertEquals((Object)this.rule.getTitle(), (Object)contentLinkSearchResult.getTitle());
    }

    @Test
    public void getContentTitleWhenNotFound() {
        Assert.assertNull((Object)this.plugin.getContentTitle(String.valueOf(RULE_ID), null));
        Assert.assertNull((Object)this.plugin.getContentTitle(String.valueOf(RULE_ID), Locale.ENGLISH));
    }

    @Test
    public void getContentTitleWhenNoLang() {
        Mockito.when((Object)this.ruleService.findRuleById(RULE_ID.longValue())).thenReturn((Object)this.rule);
        Mockito.when((Object)this.rule.getTitle()).thenReturn((Object)RULE_TITLE);
        Assert.assertEquals((Object)RULE_TITLE, (Object)this.plugin.getContentTitle(String.valueOf(RULE_ID), null));
        Assert.assertEquals((Object)RULE_TITLE, (Object)this.plugin.getContentTitle(String.valueOf(RULE_ID), Locale.ENGLISH));
    }

    @Test
    public void getContentTitle() {
        Mockito.when((Object)this.ruleService.findRuleById(RULE_ID.longValue())).thenReturn((Object)this.rule);
        Mockito.when((Object)this.rule.getTitle()).thenReturn((Object)RULE_TITLE);
        Assert.assertEquals((Object)RULE_TITLE, (Object)this.plugin.getContentTitle(String.valueOf(RULE_ID), Locale.ENGLISH));
    }
}

