/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.rest.RealizationRest;
import io.meeds.gamification.rest.model.RealizationList;
import io.meeds.gamification.rest.model.RealizationRestEntity;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.test.mock.MockHttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRealizationRest
extends AbstractServiceTest {
    protected static final long MILLIS_IN_A_DAY = 86400000L;
    protected static final String FROM_DATE = URLEncoder.encode(Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis())), StandardCharsets.UTF_8);
    protected static final String TO_DATE = URLEncoder.encode(Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 86400000L)), StandardCharsets.UTF_8);
    protected static final String JSON_TYPE = "json";
    protected static final String XLSX_TYPE = "xlsx";

    protected Class<?> getComponentClass() {
        return RealizationRest.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registry(this.getComponentClass());
    }

    @Test
    public void testGetAllRealizationsDefaultSort() throws Exception {
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=-1&limit=10&returnType=json";
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=-10&returnType=json";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=10&returnType=json";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        RealizationList realizationList = (RealizationList)response.getEntity();
        List realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)0, (int)realizations.size());
        ProgramEntity domainEntity = this.newDomain();
        this.newRealizationEntity("rule", domainEntity.getId());
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)1, (int)realizations.size());
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=10&returnType=json&returnSize=true";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        int realizationCount = realizationList.getSize();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertNotNull((Object)realizations);
        TestRealizationRest.assertEquals((int)1, (int)realizationCount);
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=10&returnType=fake&returnSize=true";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
        this.startSessionAs("root10");
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=10&returnType=json&returnSize=true";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        TestRealizationRest.assertNotNull((Object)realizationList);
        TestRealizationRest.assertEquals((int)1, (int)realizationList.getSize());
        TestRealizationRest.assertEquals((int)1, (int)realizationList.getRealizations().size());
        this.startSessionAs("notMemberUser");
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=10&returnType=json&returnSize=true";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        TestRealizationRest.assertNotNull((Object)realizationList);
        TestRealizationRest.assertEquals((int)0, (int)realizationList.getSize());
        TestRealizationRest.assertEquals((int)0, (int)realizationList.getRealizations().size());
    }

    @Test
    public void testGetAllRealizationsSortByDateDescending() throws Exception {
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=3&sortBy=date&sortDescending=true&returnType=json";
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        RealizationList realizationList = (RealizationList)response.getEntity();
        TestRealizationRest.assertEquals((int)0, (int)realizationList.getRealizations().size());
        ArrayList<RealizationEntity> createdActionHistories = new ArrayList<RealizationEntity>();
        ProgramEntity domainEntity = this.newDomain();
        for (int i = 0; i < 6; ++i) {
            createdActionHistories.add(this.newRealizationEntity("rule", domainEntity.getId()));
        }
        Collections.reverse(createdActionHistories);
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        TestRealizationRest.assertEquals((int)3, (int)realizationList.getRealizations().size());
        TestRealizationRest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), realizationList.getRealizations().stream().map(RealizationRestEntity::getId).toList());
    }

    @Test
    public void testGetAllRealizationsSortByDateAscending() throws Exception {
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=3&sortBy=date&sortDescending=false&returnType=json";
        ContainerResponse response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        RealizationList realizationList = (RealizationList)response.getEntity();
        List realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)0, (int)realizations.size());
        this.startSessionAs("root1");
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)0, (int)realizations.size());
        ArrayList<RealizationEntity> createdActionHistories = new ArrayList<RealizationEntity>();
        ProgramEntity domainEntity = this.newDomain();
        for (int i = 0; i < 6; ++i) {
            createdActionHistories.add(this.newRealizationEntity("rule", domainEntity.getId()));
        }
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)3, (int)realizations.size());
        TestRealizationRest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), realizations.stream().map(RealizationRestEntity::getId).toList());
    }

    @Test
    public void testGetAllRealizationsSortByActionTypeDescending() throws Exception {
        int i;
        RuleEntity rule1Automatic = this.newRule("testGetAllRealizationsSortByActionTypeDescending1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Manual = this.newRule("testGetAllRealizationsSortByActionTypeDescending2", "domain2", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> createdActionHistories = new ArrayList<RealizationEntity>();
        for (i = 0; i < 3; ++i) {
            createdActionHistories.add(0, this.newRealizationEntityWithRuleId(rule2Manual.getEventEntity().getTitle(), rule2Manual.getId()));
        }
        for (i = 0; i < 3; ++i) {
            createdActionHistories.add(0, this.newRealizationEntityWithRuleId(rule1Automatic.getEventEntity().getTitle(), rule1Automatic.getId()));
        }
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=3&sortBy=date&sortDescending=true&returnType=json";
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        RealizationList realizationList = (RealizationList)response.getEntity();
        List realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)3, (int)realizations.size());
        TestRealizationRest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), realizations.stream().map(RealizationRestEntity::getId).toList());
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=" + createdActionHistories.size() + "&sortBy=date&sortDescending=true&returnType=json";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)createdActionHistories.size(), (int)realizations.size());
        TestRealizationRest.assertEquals(createdActionHistories.stream().map(RealizationEntity::getId).toList(), realizations.stream().map(RealizationRestEntity::getId).toList());
    }

    @Test
    public void testGetAllRealizationsSortByActionTypeAscending() throws Exception {
        int i;
        RuleEntity rule1Automatic = this.newRule("testGetAllRealizationsSortByActionTypeDescending1", "domain1", true, EntityType.AUTOMATIC);
        RuleEntity rule2Manual = this.newRule("testGetAllRealizationsSortByActionTypeDescending2", "domain2", true, EntityType.MANUAL);
        ArrayList<RealizationEntity> createdActionHistories = new ArrayList<RealizationEntity>();
        for (i = 0; i < 3; ++i) {
            createdActionHistories.add(0, this.newRealizationEntityWithRuleId(rule1Automatic.getEventEntity().getTitle(), rule1Automatic.getId()));
        }
        for (i = 0; i < 3; ++i) {
            createdActionHistories.add(0, this.newRealizationEntityWithRuleId(rule2Manual.getEventEntity().getTitle(), rule2Manual.getId()));
        }
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=3&sortBy=date&sortDescending=true&returnType=json";
        this.startSessionAs("root1");
        ContainerResponse response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        RealizationList realizationList = (RealizationList)response.getEntity();
        List realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)3, (int)realizations.size());
        TestRealizationRest.assertEquals(createdActionHistories.subList(0, 3).stream().map(RealizationEntity::getId).toList(), realizations.stream().map(RealizationRestEntity::getId).toList());
        restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&offset=0&limit=" + createdActionHistories.size() + "&sortBy=date&sortDescending=true&returnType=json";
        response = this.getResponse("GET", this.getURLResource(restPath), null);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        realizationList = (RealizationList)response.getEntity();
        realizations = realizationList.getRealizations();
        TestRealizationRest.assertEquals((int)createdActionHistories.size(), (int)realizations.size());
        TestRealizationRest.assertEquals(createdActionHistories.stream().map(RealizationEntity::getId).toList(), realizations.stream().map(RealizationRestEntity::getId).toList());
    }

    @Test
    public void testGetReport() throws Exception {
        this.startSessionAs("root1");
        ProgramEntity domainEntity = this.newDomain();
        RealizationEntity history1 = this.newRealizationEntity("rule", domainEntity.getId());
        RealizationEntity history2 = this.newRealizationEntity("rule", domainEntity.getId());
        String restPath = "realizations?fromDate=" + FROM_DATE + "&toDate=" + TO_DATE + "&earnerIds=1&returnType=xlsx";
        EnvironmentContext environmentContext = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        environmentContext.put(HttpServletRequest.class, (Object)httpRequest);
        environmentContext.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        ContainerResponse response = this.launcher.service("GET", this.getURLResource(restPath), "", (Map)h, null, environmentContext);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        TestRealizationRest.assertNotNull((Object)inputStream);
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        TestRealizationRest.assertNotNull((Object)workbook);
        Sheet sheet = workbook.getSheetAt(0);
        TestRealizationRest.assertNotNull((Object)sheet);
        TestRealizationRest.assertEquals((int)2, (int)sheet.getLastRowNum());
        Row row1 = sheet.getRow(1);
        TestRealizationRest.assertNotNull((Object)row1);
        Row row2 = sheet.getRow(2);
        TestRealizationRest.assertNotNull((Object)row2);
        TestRealizationRest.assertEquals((String)Utils.toRFC3339Date((Date)history2.getCreatedDate()), (String)row1.getCell(0).getStringCellValue());
        TestRealizationRest.assertEquals((String)Utils.toRFC3339Date((Date)history1.getCreatedDate()), (String)row2.getCell(0).getStringCellValue());
    }

    @Test
    public void testUpdateRealization() throws Exception {
        RealizationDTO gHistory = this.newRealizationDTO();
        Long realizationId = gHistory.getId();
        RealizationDTO realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)realization.getStatus());
        this.startSessionAs("root1");
        ContainerResponse response = this.getPatchResponse(realizationId, RealizationStatus.REJECTED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)204, (int)response.getStatus());
        realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.REJECTED.name(), (String)realization.getStatus());
        response = this.getPatchResponse(realizationId, RealizationStatus.CANCELED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
        realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.REJECTED.name(), (String)realization.getStatus());
        response = this.getPatchResponse(realizationId, RealizationStatus.DELETED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
        realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.REJECTED.name(), (String)realization.getStatus());
        response = this.getPatchResponse(realizationId, RealizationStatus.ACCEPTED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)204, (int)response.getStatus());
        realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)realization.getStatus());
        response = this.getPatchResponse(5000L, RealizationStatus.REJECTED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)404, (int)response.getStatus());
        realization = this.realizationService.getRealizationById(realizationId.longValue());
        TestRealizationRest.assertEquals((String)RealizationStatus.ACCEPTED.name(), (String)realization.getStatus());
        this.startSessionAs("root10");
        response = this.getPatchResponse(realizationId, RealizationStatus.REJECTED);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testGetAllPointsByUserId() throws Exception {
        this.newRealizationDTO();
        String restPath = "/gamification/realizations/points?userId=root1&period=MONTH";
        EnvironmentContext envctx = new EnvironmentContext();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        ContainerResponse response = this.launcher.service("GET", restPath, "", null, null, envctx);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        TestRealizationRest.assertEquals((String)"50", (String)response.getEntity().toString());
        restPath = "/gamification/realizations/points?userId=root1&period=WEEK";
        envctx = new EnvironmentContext();
        httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        response = this.launcher.service("GET", restPath, "", null, null, envctx);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)200, (int)response.getStatus());
        TestRealizationRest.assertEquals((String)"50", (String)response.getEntity().toString());
        restPath = "/gamification/realizations/points?period=MONTH";
        envctx = new EnvironmentContext();
        httpRequest = new MockHttpServletRequest(restPath, null, 0, "GET", null);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        envctx.put(SecurityContext.class, (Object)new AbstractServiceTest.MockSecurityContext("root"));
        response = this.launcher.service("GET", restPath, "", null, null, envctx);
        TestRealizationRest.assertNotNull((Object)response);
        TestRealizationRest.assertEquals((int)400, (int)response.getStatus());
    }

    private ContainerResponse getPatchResponse(long realizationId, RealizationStatus status) throws Exception {
        byte[] formData = ("id=" + realizationId + "&status=" + String.valueOf(status)).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        return this.launcher.service("PATCH", this.getURLResource("realizations"), "", (Map)headers, formData, null);
    }
}

