/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RulePublication;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.mapper.RuleMapper;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Test;

public class RuleServiceTest
extends AbstractServiceTest {
    private static final String ROOT1 = "root1";
    private static final String RULE2 = "rule2";
    private static final String RULE1 = "rule1";
    private static final String PROGRAM1 = "domain1";
    private static final String PROGRAM2 = "domain2";
    private static final String RULE_DESCRIPTION = "Description";
    private static final String INTERNAL_USER = "root50";
    private static final String SPACE_MEMBER_USER = "root10";
    private static final String ADMIN_USER = "root1";
    private Identity adminAclIdentity;

    @Override
    public void setUp() {
        super.setUp();
        this.adminAclIdentity = this.registerAdministratorUser("root1");
        this.registerInternalUser(SPACE_MEMBER_USER);
        this.registerInternalUser(INTERNAL_USER);
    }

    @Test
    public void testFindRuleById() {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        RuleEntity ruleEntity = this.newRule();
        RuleServiceTest.assertNotNull((Object)this.ruleService.findRuleById(ruleEntity.getId().longValue()));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleService.findRuleById(0L));
    }

    @Test
    public void testFindRuleByTitle() {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        this.newRule();
        RuleServiceTest.assertNotNull((Object)this.ruleService.findRuleByTitle("createNewTask"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleService.findRuleByTitle(null));
    }

    @Test
    public void testFindRuleByIdAndUser() throws IllegalAccessException, ObjectNotFoundException {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RuleServiceTest.assertNotNull((Object)rule);
        Long ruleId = rule.getId();
        RuleDTO foundRule = this.ruleService.findRuleById(ruleId.longValue(), "root1");
        RuleServiceTest.assertNotNull((Object)foundRule);
        long activityId = foundRule.getActivityId();
        RuleServiceTest.assertTrue((activityId > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        activity.isHidden(false);
        this.activityManager.updateActivity(activity);
        activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertFalse((boolean)activity.isHidden());
        this.ruleService.deleteRuleById(ruleId.longValue(), "root1");
        activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNull((Object)activity);
    }

    @Test
    public void testSwitchRuleAudience() throws IllegalAccessException, ObjectNotFoundException {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RuleServiceTest.assertNotNull((Object)rule);
        Long ruleId = rule.getId();
        RuleDTO foundRule = this.ruleService.findRuleById(ruleId.longValue(), "root1");
        RuleServiceTest.assertNotNull((Object)foundRule);
        long activityId = foundRule.getActivityId();
        RuleServiceTest.assertTrue((activityId > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        activity.isHidden(false);
        this.activityManager.updateActivity(activity);
        activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertFalse((boolean)activity.isHidden());
        long programId = rule.getProgram().getId();
        ProgramDTO program = this.programService.getProgramById(programId);
        program.setSpaceId(Long.parseLong("152"));
        this.programService.updateProgram(program);
        foundRule = this.ruleService.findRuleById(ruleId.longValue(), "root1");
        RuleServiceTest.assertNotNull((Object)foundRule);
        RuleServiceTest.assertTrue((boolean)foundRule.isEnabled());
        RuleServiceTest.assertFalse((boolean)foundRule.isDeleted());
        Assert.assertNotEquals((long)0L, (long)foundRule.getActivityId());
        Assert.assertNotEquals((long)activityId, (long)foundRule.getActivityId());
        activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        activity = this.activityManager.getActivity(String.valueOf(foundRule.getActivityId()));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
    }

    @Test
    public void testFindRuleAfterDomainAudienceChange() throws IllegalAccessException, ObjectNotFoundException {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RuleServiceTest.assertNotNull((Object)rule);
        ProgramDTO program = rule.getProgram();
        RuleServiceTest.assertNotNull((Object)program);
        RuleServiceTest.assertNotNull((Object)this.ruleService.findRuleById(rule.getId().longValue()));
        program.setSpaceId(program.getSpaceId() + 1L);
        ProgramDTO updatedProgram = this.programService.updateProgram(program, this.adminAclIdentity);
        RuleDTO updatedRuleAudience = this.ruleService.findRuleById(rule.getId().longValue());
        RuleServiceTest.assertNotNull((Object)updatedRuleAudience);
        RuleServiceTest.assertNotNull((Object)updatedRuleAudience.getProgram());
        RuleServiceTest.assertEquals((long)program.getId(), (long)updatedRuleAudience.getProgram().getId());
        RuleServiceTest.assertEquals((long)program.getSpaceId(), (long)updatedRuleAudience.getProgram().getSpaceId());
        RuleServiceTest.assertEquals((long)updatedProgram.getSpaceId(), (long)updatedRuleAudience.getProgram().getSpaceId());
    }

    @Test
    public void testDeleteRule() {
        RuleEntity ruleEntity = this.newRule();
        RuleServiceTest.assertFalse((boolean)ruleEntity.isDeleted());
        this.ruleService.deleteRuleById(ruleEntity.getId().longValue(), "root1");
        RuleServiceTest.assertTrue((boolean)ruleEntity.isDeleted());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleService.deleteRuleById(0L, "root"));
    }

    @Test
    public void testDeleteNotEndedRule() {
        RuleEntity ruleEntity = this.newRule();
        RuleServiceTest.assertFalse((boolean)ruleEntity.isDeleted());
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(ruleEntity.getEventEntity().getTitle(), null, "1", "10", "245590", "activity").get(0);
        RuleServiceTest.assertNotNull((Object)realization);
        RuleServiceTest.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        RealizationFilter identityFilter = new RealizationFilter();
        identityFilter.setEarnerIds(Collections.singletonList("1"));
        List realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RuleServiceTest.assertNotNull((Object)realizations);
        RuleServiceTest.assertEquals((int)1, (int)realizations.size());
        RealizationDTO latestRealization = (RealizationDTO)realizations.get(0);
        RuleServiceTest.assertNotNull((Object)latestRealization);
        RuleServiceTest.assertEquals((Object)realization.getId(), (Object)latestRealization.getId());
        RuleDTO rule = this.ruleService.deleteRuleById(ruleEntity.getId().longValue(), "root1");
        RuleServiceTest.assertNotNull((Object)rule);
        RuleServiceTest.assertTrue((boolean)rule.isDeleted());
        this.restartTransaction();
        rule = this.ruleService.findRuleById(rule.getId().longValue());
        RuleServiceTest.assertNotNull((Object)rule);
        realizations = this.realizationService.getRealizationsByFilter(identityFilter, 0, 1);
        RuleServiceTest.assertNotNull((Object)realizations);
        RuleServiceTest.assertEquals((int)1, (int)realizations.size());
        latestRealization = (RealizationDTO)realizations.get(0);
        RuleServiceTest.assertNotNull((Object)latestRealization);
        RuleServiceTest.assertEquals((Object)realization.getId(), (Object)latestRealization.getId());
    }

    @Test
    public void testCreateRule() {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleService.createRule(null, SPACE_MEMBER_USER));
        RuleEntity rule = new RuleEntity();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription(RULE_DESCRIPTION);
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setEventEntity(this.newEvent("createNewTask"));
        rule.setCreatedBy("1");
        rule.setCreatedDate(new Date());
        rule.setLastModifiedBy("1");
        rule.setLastModifiedDate(new Date());
        rule.setDomainEntity(this.newDomain("TeamWork"));
        rule.setType(EntityType.AUTOMATIC);
        rule.setRecurrence(RecurrenceType.NONE);
        this.ruleService.createRule(RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)rule), "root1");
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)1);
    }

    @Test
    public void testCreateRuleWithNoEvent() {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleService.createRule(null, SPACE_MEMBER_USER));
        RuleEntity rule = new RuleEntity();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription(RULE_DESCRIPTION);
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setCreatedBy("1");
        rule.setCreatedDate(new Date());
        rule.setLastModifiedBy("1");
        rule.setLastModifiedDate(new Date());
        rule.setDomainEntity(this.newDomain("TeamWork"));
        rule.setType(EntityType.AUTOMATIC);
        rule.setRecurrence(RecurrenceType.NONE);
        this.ruleService.createRule(RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)rule), "root1");
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)1);
        this.ruleService.createRule(RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)rule), "root1");
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)2);
    }

    @Test
    public void testUpdateRule() {
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)0);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.ruleService.updateRule(new RuleDTO(), "root"));
        RuleDTO createdRule = this.ruleService.findRuleById(this.newRuleDTO().getId().longValue(), "root1");
        long activityId = createdRule.getActivityId();
        RuleServiceTest.assertTrue((activityId > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        RuleServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)activity.getTitle()));
        RuleServiceTest.assertNotNull((Object)activity.getActivityStream());
        RuleServiceTest.assertTrue((boolean)activity.getActivityStream().isSpace());
        Space space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId());
        RuleServiceTest.assertNotNull((Object)space);
        RuleServiceTest.assertEquals((long)createdRule.getSpaceId(), (long)Long.parseLong(space.getId()));
        String message = "Text Message";
        String description = "new_description";
        String paramName = "testParam";
        String paramValue = "testValue";
        RulePublication rule = new RulePublication(createdRule, 0L, message, Collections.singletonMap(paramName, paramValue), true);
        rule.setDescription(description);
        this.ruleService.updateRule((RuleDTO)rule, "root1");
        RuleDTO updatedRule = this.ruleService.findRuleById(createdRule.getId().longValue());
        RuleServiceTest.assertEquals((String)description, (String)updatedRule.getDescription());
        Assert.assertThrows(IllegalAccessException.class, () -> this.ruleService.updateRule(updatedRule, SPACE_MEMBER_USER));
        activity = this.activityManager.getActivity(String.valueOf(activityId));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertFalse((boolean)activity.isHidden());
        RuleServiceTest.assertEquals((String)String.valueOf(activityId), (String)activity.getId());
        RuleServiceTest.assertEquals((String)message, (String)activity.getTitle());
        RuleServiceTest.assertNotNull((Object)activity.getTemplateParams());
        RuleServiceTest.assertEquals((String)paramValue, (String)((String)activity.getTemplateParams().get(paramName)));
        Assert.assertNotEquals((Object)createdRule.getProgram().getLastModifiedDate(), (Object)updatedRule.getProgram().getLastModifiedDate());
        this.ruleService.deleteRuleById(rule.getId().longValue(), "root1");
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.ruleService.updateRule(updatedRule, "root"));
    }

    @Test
    public void testCreateRuleWithPublication() {
        final AtomicInteger triggerCount = new AtomicInteger(0);
        this.listenerService.addListener("rule.published", (ListenerBase)new Listener<RuleDTO, String>(this){

            public void onEvent(Event<RuleDTO, String> event) {
                triggerCount.incrementAndGet();
            }
        });
        ProgramDTO program = this.newProgram("TeamWork");
        RulePublication rule = new RulePublication();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription(RULE_DESCRIPTION);
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setEvent(this.newEventDTO("createNewTask"));
        rule.setProgram(program);
        rule.setType(EntityType.AUTOMATIC);
        rule.setRecurrence(RecurrenceType.NONE);
        rule.setPublish(true);
        String message = "Test publication Message";
        rule.setMessage(message);
        RuleDTO createdRule = this.ruleService.createRule((RuleDTO)rule, "root1");
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)1);
        RuleServiceTest.assertTrue((createdRule.getActivityId() > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(createdRule.getActivityId()));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertFalse((boolean)activity.isHidden());
        RuleServiceTest.assertNotNull((Object)activity.getActivityStream());
        RuleServiceTest.assertTrue((boolean)activity.getActivityStream().isSpace());
        Space space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId());
        RuleServiceTest.assertNotNull((Object)space);
        RuleServiceTest.assertEquals((long)createdRule.getSpaceId(), (long)Long.parseLong(space.getId()));
        RuleServiceTest.assertEquals((String)message, (String)activity.getTitle());
        RuleServiceTest.assertEquals((String)"rule", (String)activity.getMetadataObjectType());
        RuleServiceTest.assertEquals((String)String.valueOf(createdRule.getId()), (String)activity.getMetadataObjectId());
        RuleServiceTest.assertEquals((int)1, (int)triggerCount.get());
    }

    @Test
    public void testCreateRuleWithoutPublication() {
        final AtomicInteger triggerCount = new AtomicInteger(0);
        this.listenerService.addListener("rule.published", (ListenerBase)new Listener<RuleDTO, String>(this){

            public void onEvent(Event<RuleDTO, String> event) {
                triggerCount.incrementAndGet();
            }
        });
        ProgramDTO program = this.newProgram("TeamWork");
        RulePublication rule = new RulePublication();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription(RULE_DESCRIPTION);
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setEvent(this.newEventDTO("createNewTask"));
        rule.setProgram(program);
        rule.setType(EntityType.AUTOMATIC);
        rule.setRecurrence(RecurrenceType.NONE);
        rule.setPublish(false);
        String message = "Test publication Message";
        rule.setMessage(message);
        rule.setSpaceId(program.getSpaceId());
        RuleDTO createdRule = this.ruleService.createRule((RuleDTO)rule, "root1");
        RuleServiceTest.assertEquals((int)this.ruleDAO.findAll().size(), (int)1);
        RuleServiceTest.assertTrue((createdRule.getActivityId() > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(createdRule.getActivityId()));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        RuleServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)activity.getTitle()));
        RuleServiceTest.assertTrue((boolean)activity.getActivityStream().isSpace());
        Space space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId());
        RuleServiceTest.assertNotNull((Object)space);
        RuleServiceTest.assertEquals((long)createdRule.getSpaceId(), (long)Long.parseLong(space.getId()));
        RuleServiceTest.assertEquals((int)0, (int)triggerCount.get());
    }

    @Test
    public void testGetRulesByAdmin() {
        this.newRuleDTO();
        ProgramEntity domainEntity1 = this.newDomain(PROGRAM1);
        ProgramEntity domainEntity2 = this.newDomain(PROGRAM2);
        RuleDTO ruleDTO1 = this.newRuleDTO(RULE1, domainEntity1.getId());
        ruleDTO1.setEnabled(false);
        this.ruleService.updateRule(ruleDTO1, "root1");
        RuleDTO ruleDTO2 = this.newRuleDTO(RULE2, domainEntity2.getId());
        ruleDTO2.setEnabled(false);
        this.ruleService.updateRule(ruleDTO2, "root1");
        RuleFilter filter = new RuleFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        List rules = this.ruleService.getRules(filter, "root1", 0, 10);
        RuleServiceTest.assertEquals((int)1, (int)rules.size());
        filter.setStatus(EntityStatusType.DISABLED);
        rules = this.ruleService.getRules(filter, "root1", 0, 10);
        RuleServiceTest.assertEquals((int)2, (int)rules.size());
        filter.setStatus(EntityStatusType.ALL);
        ProgramDTO domain = this.programService.getProgramByTitle("TeamWork");
        long domainId = domain.getId();
        filter.setProgramId(domainId);
        rules = this.ruleService.getRules(filter, "root1", 0, 10);
        RuleServiceTest.assertEquals((int)1, (int)rules.size());
        filter.setType(EntityFilterType.MANUAL);
        rules = this.ruleService.getRules(filter, "root1", 0, 10);
        RuleServiceTest.assertEquals((int)0, (int)rules.size());
        filter = new RuleFilter();
        filter.setType(EntityFilterType.AUTOMATIC);
        rules = this.ruleService.getRules(filter, "root1", 0, 10);
        RuleServiceTest.assertEquals((int)3, (int)rules.size());
        RuleServiceTest.assertEquals((int)3, (int)this.ruleDAO.count().intValue());
        RuleServiceTest.assertTrue((String)"Enabled rule should have an automatic generated activity", (((RuleDTO)rules.get(0)).getActivityId() > 0L ? 1 : 0) != 0);
        RuleServiceTest.assertEquals((String)"Disabled rule shouldn't have an automatic generated activity", (long)0L, (long)((RuleDTO)rules.get(1)).getActivityId());
        RuleServiceTest.assertEquals((String)"Disabled rule shouldn't have an automatic generated activity", (long)0L, (long)((RuleDTO)rules.get(2)).getActivityId());
    }

    @Test
    public void testGetRulesBySpaceMember() {
        this.newRuleDTO();
        ProgramEntity domainEntity1 = this.newDomain(PROGRAM1);
        ProgramEntity domainEntity2 = this.newDomain(PROGRAM2);
        RuleDTO ruleDTO1 = this.newRuleDTO(RULE1, domainEntity1.getId());
        ruleDTO1.setEnabled(false);
        this.ruleService.updateRule(ruleDTO1, "root1");
        RuleDTO ruleDTO2 = this.newRuleDTO(RULE2, domainEntity2.getId());
        ruleDTO2.setEnabled(false);
        this.ruleService.updateRule(ruleDTO2, "root1");
        RuleFilter filter = new RuleFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        RuleServiceTest.assertEquals((int)1, (int)this.ruleService.getRules(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        RuleServiceTest.assertEquals((int)2, (int)this.ruleService.getRules(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        ProgramDTO domain = this.programService.getProgramByTitle("TeamWork");
        long domainId = domain.getId();
        filter.setProgramId(domainId);
        RuleServiceTest.assertEquals((int)1, (int)this.ruleService.getRules(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter = new RuleFilter();
        filter.setType(EntityFilterType.AUTOMATIC);
        RuleServiceTest.assertEquals((int)3, (int)this.ruleService.getRules(filter, SPACE_MEMBER_USER, 0, 10).size());
        RuleServiceTest.assertEquals((int)3, (int)this.ruleDAO.count().intValue());
    }

    @Test
    public void testGetRulesByNonMemberUser() {
        this.newRuleDTO();
        ProgramEntity domainEntity1 = this.newDomain(PROGRAM1);
        ProgramEntity domainEntity2 = this.newDomain(PROGRAM2);
        RuleDTO ruleDTO1 = this.newRuleDTO(RULE1, domainEntity1.getId());
        ruleDTO1.setEnabled(false);
        this.ruleService.updateRule(ruleDTO1, "root1");
        RuleDTO ruleDTO2 = this.newRuleDTO(RULE2, domainEntity2.getId());
        ruleDTO2.setEnabled(false);
        this.ruleService.updateRule(ruleDTO2, "root1");
        RuleFilter filter = new RuleFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        ProgramDTO domain = this.programService.getProgramByTitle("TeamWork");
        long domainId = domain.getId();
        filter.setProgramId(domainId);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter = new RuleFilter();
        filter.setType(EntityFilterType.AUTOMATIC);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        RuleServiceTest.assertEquals((int)3, (int)this.ruleDAO.count().intValue());
    }

    @Test
    public void testGetOpenRulesByInternalUser() {
        RuleDTO ruleDTO = this.newRuleDTO();
        ProgramDTO program = ruleDTO.getProgram();
        program.setOpen(true);
        this.programService.updateProgram(program, this.adminAclIdentity);
        ProgramEntity domainEntity1 = this.newOpenProgram(PROGRAM1);
        ProgramEntity domainEntity2 = this.newOpenProgram(PROGRAM2);
        RuleDTO rule1 = this.newRuleDTO(RULE1, domainEntity1.getId());
        rule1 = this.ruleService.findRuleById(rule1.getId().longValue(), "root1");
        RuleServiceTest.assertTrue((rule1.getActivityId() > 0L ? 1 : 0) != 0);
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(rule1.getActivityId()));
        RuleServiceTest.assertNotNull((Object)activity);
        RuleServiceTest.assertTrue((boolean)activity.isHidden());
        RuleServiceTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)activity.getTitle()));
        RuleServiceTest.assertTrue((boolean)activity.getActivityStream().isUser());
        RuleServiceTest.assertEquals((String)"root1", (String)activity.getActivityStream().getPrettyId());
        rule1.setEnabled(false);
        this.ruleService.updateRule(rule1, "root1");
        RuleDTO ruleDTO2 = this.newRuleDTO(RULE2, domainEntity2.getId());
        ruleDTO2.setEnabled(false);
        this.ruleService.updateRule(ruleDTO2, "root1");
        RuleFilter filter = new RuleFilter();
        filter.setStatus(EntityStatusType.ENABLED);
        RuleServiceTest.assertEquals((int)1, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        RuleServiceTest.assertEquals((int)2, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        ProgramDTO domain = this.programService.getProgramByTitle("TeamWork");
        long domainId = domain.getId();
        filter.setProgramId(domainId);
        RuleServiceTest.assertEquals((int)1, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        filter = new RuleFilter();
        filter.setType(EntityFilterType.AUTOMATIC);
        RuleServiceTest.assertEquals((int)3, (int)this.ruleService.getRules(filter, INTERNAL_USER, 0, 10).size());
        RuleServiceTest.assertEquals((int)3, (int)this.ruleDAO.count().intValue());
    }
}

