/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.activity.processor;

import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.service.RealizationService;
import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class AnnouncementActivityPreProcessor
extends BaseActivityProcessorPlugin {
    private final RealizationService realizationService;

    public AnnouncementActivityPreProcessor(RealizationService realizationService, InitParams params) {
        super(params);
        this.realizationService = realizationService;
    }

    public boolean isPreActivityProcessor() {
        return true;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (!"gamificationActionAnnouncement".equals(activity.getType())) {
            return;
        }
        long realizationId = Long.parseLong((String)activity.getTemplateParams().get("announcementId"));
        RealizationDTO realization = this.realizationService.getRealizationById(realizationId);
        if (realization == null) {
            return;
        }
        if (!RealizationStatus.CANCELED.name().equals(realization.getStatus()) && !RealizationStatus.DELETED.name().equals(realization.getStatus()) && realization.getActivityId() != null) {
            Map templateParams = activity.getTemplateParams();
            templateParams.put("realizationStatus", String.valueOf(realization.getStatus()));
            templateParams.put("realizationCreatedDate", realization.getCreatedDate());
            activity.setTemplateParams(templateParams);
        }
    }
}

