/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.injection.ProgramImportService;
import io.meeds.gamification.service.injection.ProgramTranslationImportService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProgramImportServiceTest
extends BaseExoTestCase {
    @Mock
    private ProgramService programService;
    @Mock
    private RuleService ruleService;
    @Mock
    private TranslationService translationService;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private FileService fileService;
    @Mock
    private SettingService settingService;
    @Mock
    private LocaleConfig defaultLocaleConfig;
    @Mock
    private ConfigurationManager configurationManager;
    @Mock
    private UserACL userACL;
    @Mock
    private ProgramTranslationImportService programTranslationImportService;
    @InjectMocks
    private ProgramImportService importService;

    @Before
    public void setup() {
        HashMap settingValues = new HashMap();
        ((SettingService)Mockito.doAnswer(invocation -> {
            Context context = (Context)invocation.getArgument(0, Context.class);
            Scope scope = (Scope)invocation.getArgument(1, Scope.class);
            String key = (String)invocation.getArgument(2, String.class);
            String settingKey = context.getId() + context.getName() + scope.getId() + scope.getName() + key;
            settingValues.put(settingKey, "1");
            return null;
        }).when((Object)this.settingService)).set((Context)Mockito.any(Context.class), (Scope)Mockito.any(Scope.class), Mockito.anyString(), (SettingValue)Mockito.any(SettingValue.class));
        Mockito.when((Object)this.settingService.get((Context)Mockito.any(Context.class), (Scope)Mockito.any(Scope.class), Mockito.anyString())).thenAnswer(invocation -> {
            Context context = (Context)invocation.getArgument(0, Context.class);
            Scope scope = (Scope)invocation.getArgument(1, Scope.class);
            String key = (String)invocation.getArgument(2, String.class);
            String settingKey = context.getId() + context.getName() + scope.getId() + scope.getName() + key;
            String value = (String)settingValues.get(settingKey);
            return value == null ? null : SettingValue.create((String)value);
        });
    }

    @Test
    public void init() {
        try {
            this.importService.init();
        }
        catch (Exception e) {
            ProgramImportServiceTest.fail((String)"Shouldn't stop the container initialization if import default programs fails");
        }
        try {
            ProgramDTO programDTO = new ProgramDTO();
            programDTO.setId(1L);
            programDTO.setTitle("Sample Program");
            Mockito.when((Object)this.programService.countPrograms((ProgramFilter)Mockito.any(ProgramFilter.class))).thenReturn((Object)0);
            Mockito.when((Object)this.programService.createProgram((ProgramDTO)Mockito.any(ProgramDTO.class))).thenReturn((Object)programDTO);
            Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
            Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
            LocaleConfig otherLocaleConfig = (LocaleConfig)Mockito.mock(LocaleConfig.class);
            Mockito.when((Object)otherLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
            Mockito.when((Object)this.localeConfigService.getLocalConfigs()).thenReturn(Arrays.asList(this.defaultLocaleConfig, otherLocaleConfig));
            RuleDTO ruleDTO = new RuleDTO();
            ruleDTO.setId(Long.valueOf(1L));
            ruleDTO.setTitle("Sample Rule");
            Mockito.when((Object)this.ruleService.createRule((RuleDTO)Mockito.any(RuleDTO.class))).thenReturn((Object)ruleDTO);
            Mockito.when((Object)this.ruleService.findRuleByTitle(Mockito.anyString())).thenReturn((Object)ruleDTO);
            Mockito.when((Object)this.ruleService.findRuleById(Mockito.anyLong())).thenReturn((Object)ruleDTO);
            this.importService.importPrograms();
        }
        catch (Exception e) {
            ProgramImportServiceTest.fail((String)"Shouldn't stop the container initialization if import default programs fails");
        }
    }
}

