/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.search;

import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.search.RuleSearchConnector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleSearchConnectorTest {
    private static final String ES_INDEX = "rule_alias";
    public static final String FAKE_ES_QUERY = "    {\n      \"from\": \"@offset@\",\n      \"size\": \"@limit@\",\n      \"query\": {\n        \"bool\": {\n          \"must\": [\n            @search_filtering@\n          ]\n        }\n      }\n    }\n";
    private ConfigurationManager configurationManager;
    private ElasticSearchingClient client;
    private String searchResult = null;
    private RuleSearchConnector ruleSearchConnector;

    @Before
    public void setUp() throws Exception {
        this.configurationManager = (ConfigurationManager)Mockito.mock(ConfigurationManager.class);
        this.client = (ElasticSearchingClient)Mockito.mock(ElasticSearchingClient.class);
        try {
            this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("rule-search-result.json"));
            Mockito.reset((Object[])new ConfigurationManager[]{this.configurationManager});
            Mockito.when((Object)this.configurationManager.getInputStream("FILE_PATH")).thenReturn((Object)new ByteArrayInputStream(FAKE_ES_QUERY.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving ES Query content", e);
        }
        this.ruleSearchConnector = new RuleSearchConnector(this.configurationManager, this.client, this.getParams());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("index", ES_INDEX);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("query.file.path");
        valueParam.setValue("FILE_PATH");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)valueParam);
        return params;
    }

    @Test
    public void testSearch() {
        String term = "rule";
        RuleFilter filter = new RuleFilter();
        List<Long> listIdSpace = Collections.singletonList(1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleSearchConnector.search(filter, -1L, 10L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleSearchConnector.search(filter, 0L, -10L));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.ruleSearchConnector.search(filter, 0L, 10L));
        filter.setTerm("test");
        filter.setLocale(Locale.ENGLISH);
        filter.setSpaceIds(listIdSpace);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> StringUtils.contains((CharSequence)esQuery, (CharSequence)term)), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> !StringUtils.contains((CharSequence)esQuery, (CharSequence)term)), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)"{}");
        List ruleIds = this.ruleSearchConnector.search(filter, 0L, 10L);
        Assert.assertNotNull((Object)ruleIds);
        Assert.assertEquals((long)0L, (long)ruleIds.size());
        filter.setTerm(term);
        ruleIds = this.ruleSearchConnector.search(filter, 0L, 10L);
        Assert.assertNotNull((Object)ruleIds);
        Assert.assertEquals((long)1L, (long)ruleIds.size());
    }

    @Test
    public void testSearchWithProgramIdAnAudience() {
        String term = "ALL";
        long programId = 256668L;
        RuleFilter filter = new RuleFilter();
        long spaceId = 155568L;
        filter.setLocale(Locale.ENGLISH);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> StringUtils.containsIgnoreCase((CharSequence)esQuery, (CharSequence)term) && StringUtils.contains((CharSequence)esQuery, (CharSequence)String.valueOf(programId)) && StringUtils.contains((CharSequence)esQuery, (CharSequence)String.valueOf(spaceId))), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        Mockito.when((Object)this.client.sendRequest((String)ArgumentMatchers.argThat(esQuery -> !StringUtils.containsIgnoreCase((CharSequence)esQuery, (CharSequence)term) || !StringUtils.contains((CharSequence)esQuery, (CharSequence)String.valueOf(programId)) || !StringUtils.contains((CharSequence)esQuery, (CharSequence)String.valueOf(spaceId))), (String)ArgumentMatchers.eq((Object)ES_INDEX))).thenReturn((Object)"{}");
        filter.setProgramId(programId);
        List ruleIds = this.ruleSearchConnector.search(filter, 0L, 10L);
        Assert.assertNotNull((Object)ruleIds);
        Assert.assertEquals((long)0L, (long)ruleIds.size());
        filter.setSpaceIds(Collections.singletonList(spaceId));
        ruleIds = this.ruleSearchConnector.search(filter, 0L, 10L);
        Assert.assertNotNull((Object)ruleIds);
        Assert.assertEquals((long)0L, (long)ruleIds.size());
        filter.setTerm(term);
        ruleIds = this.ruleSearchConnector.search(filter, 0L, 10L);
        Assert.assertNotNull((Object)ruleIds);
        Assert.assertEquals((long)1L, (long)ruleIds.size());
    }
}

