/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.GamificationNotificationListener;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationNotificationListenerTest {
    private static final String IDENTITY_ID = "1";
    private static final String USERNAME = "test";
    @Mock
    private ListenerService listenerService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private Event<String, UserSetting> event;
    @Mock
    private Identity identity;

    @Before
    public void setup() {
        Mockito.when((Object)this.identity.getId()).thenReturn((Object)IDENTITY_ID);
        Mockito.when((Object)this.identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.identity);
        Mockito.when((Object)((String)this.event.getSource())).thenReturn((Object)USERNAME);
    }

    @Test
    public void testOnEvent() throws Exception {
        GamificationNotificationListener gamificationNotificationListener = new GamificationNotificationListener(this.identityManager, this.listenerService);
        gamificationNotificationListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("addUserProfileNotificationSetting") && ((String)source.get("senderId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("receiverId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("objectType")).equals("identity") && ((String)source.get("objectId")).equals(this.identity.getId()))), ArgumentMatchers.eq(null));
    }
}

