/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.rest.LeaderboardRest;
import io.meeds.gamification.rest.model.LeaderboardInfo;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import java.util.List;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.junit.Before;
import org.junit.Test;

public class TestLeaderboardRest
extends AbstractServiceTest {
    private static final String BASE_URL = "leaderboard";
    private long programId1;
    private long programId2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.registry(LeaderboardRest.class);
    }

    @Test
    public void testGetLeaderboardResultDetails() throws Exception {
        this.populateData();
        ContainerResponse response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=10"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        List leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfos.size());
        LeaderboardInfo leaderboardInfo = (LeaderboardInfo)leaderboardInfos.get(0);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo);
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getProfileUrl());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getRemoteId());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getTechnicalId());
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getFullname());
        TestLeaderboardRest.assertEquals((int)1, (int)leaderboardInfo.getRank());
        TestLeaderboardRest.assertEquals((long)200L, (long)leaderboardInfo.getScore());
        TestLeaderboardRest.assertEquals((long)1L, (long)leaderboardInfo.getIdentityId());
        leaderboardInfo = (LeaderboardInfo)leaderboardInfos.get(1);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo);
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getProfileUrl());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getRemoteId());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getTechnicalId());
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getFullname());
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfo.getRank());
        TestLeaderboardRest.assertEquals((long)150L, (long)leaderboardInfo.getScore());
        TestLeaderboardRest.assertEquals((long)2L, (long)leaderboardInfo.getIdentityId());
        this.startSessionAs("root1");
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=10"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfos.size());
        leaderboardInfo = (LeaderboardInfo)leaderboardInfos.get(0);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getRemoteId());
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getFullname());
        TestLeaderboardRest.assertEquals((int)1, (int)leaderboardInfo.getRank());
        TestLeaderboardRest.assertEquals((long)200L, (long)leaderboardInfo.getScore());
        TestLeaderboardRest.assertEquals((long)1L, (long)leaderboardInfo.getIdentityId());
        leaderboardInfo = (LeaderboardInfo)leaderboardInfos.get(1);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getRemoteId());
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getFullname());
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfo.getRank());
        TestLeaderboardRest.assertEquals((long)150L, (long)leaderboardInfo.getScore());
        TestLeaderboardRest.assertEquals((long)2L, (long)leaderboardInfo.getIdentityId());
    }

    @Test
    public void testGetLeaderboard() throws Exception {
        this.populateData();
        ContainerResponse response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=10"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        List leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfos.size());
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=0"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)0, (int)leaderboardInfos.size());
        this.startSessionAs("root1");
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&identityId=1&limit=0"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)1, (int)leaderboardInfos.size());
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&identityId=1&limit=10"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfos.size());
        this.resetUserSession();
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=10&programId=" + this.programId2), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=10&programId=" + this.programId1), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)2, (int)leaderboardInfos.size());
    }

    @Test
    public void testGetLeaderboardByAnonymous() throws Exception {
        this.newRealizationDTO();
        this.newRealizationDTO();
        this.newRealizationDTO();
        ContainerResponse response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        List leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)0, (int)leaderboardInfos.size());
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=ALL&limit=6"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        leaderboardInfos = (List)response.getEntity();
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfos);
        TestLeaderboardRest.assertEquals((int)1, (int)leaderboardInfos.size());
        LeaderboardInfo leaderboardInfo = (LeaderboardInfo)leaderboardInfos.get(0);
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo);
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getProfileUrl());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getRemoteId());
        TestLeaderboardRest.assertNull((Object)leaderboardInfo.getTechnicalId());
        TestLeaderboardRest.assertNotNull((Object)leaderboardInfo.getFullname());
        TestLeaderboardRest.assertEquals((int)1, (int)leaderboardInfo.getRank());
        TestLeaderboardRest.assertEquals((long)150L, (long)leaderboardInfo.getScore());
        TestLeaderboardRest.assertEquals((long)1L, (long)leaderboardInfo.getIdentityId());
    }

    @Test
    public void testGetLeaderboardByAnonymousWhenRestricted() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("leaderboard?period=MONTH"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=MONTH&identityType=SPACE&limit=10"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)401, (int)response.getStatus());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("leaderboard?period=MONTH"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void testGetStatsByAnonymousWhenRestricted() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("leaderboard/stats/1"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)200, (int)response.getStatus());
        this.setRestrictedHubAccess();
        response = this.getResponse("GET", this.getURLResource("leaderboard/stats/1"), null);
        TestLeaderboardRest.assertNotNull((Object)response);
        TestLeaderboardRest.assertEquals((int)401, (int)response.getStatus());
    }

    private void populateData() {
        Date createDate = new Date(System.currentTimeMillis());
        Date lastModifiedDate = new Date(System.currentTimeMillis() + 10L);
        ProgramDTO program1 = new ProgramDTO();
        String programTitle1 = "program1";
        String programTitle2 = "program2";
        program1.setTitle(programTitle1);
        program1.setDescription("Description");
        program1.setCreatedBy("1");
        program1.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        program1.setLastModifiedBy("1");
        program1.setDeleted(false);
        program1.setEnabled(true);
        program1.setSpaceId(Long.parseLong("152"));
        program1.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        program1 = this.programService.createProgram(program1);
        this.programId1 = program1.getId();
        ProgramDTO program2 = new ProgramDTO();
        program2.setTitle(programTitle2);
        program2.setDescription("Description");
        program2.setCreatedBy("1");
        program2.setCreatedDate(Utils.toRFC3339Date((Date)createDate));
        program2.setLastModifiedBy("1");
        program2.setDeleted(false);
        program2.setEnabled(true);
        program1.setSpaceId(Long.parseLong("152"));
        program2.setLastModifiedDate(Utils.toRFC3339Date((Date)lastModifiedDate));
        program2 = this.programService.createProgram(program2);
        this.programId2 = program2.getId();
        RuleEntity rule1 = this.newRule("rule1", this.programId1);
        RuleEntity rule2 = this.newRule("rule2", this.programId1);
        RuleEntity rule3 = this.newRule("rule3", this.programId2);
        this.newRealizationByRuleByEarnerId(rule1, "1");
        this.newRealizationByRuleByEarnerId(rule1, "2");
        this.newRealizationByRuleByEarnerId(rule1, "1");
        this.newRealizationByRuleByEarnerId(rule2, "2");
        this.newRealizationByRuleByEarnerId(rule2, "1");
        this.newRealizationByRuleByEarnerId(rule2, "2");
        this.newRealizationByRuleByEarnerId(rule3, "1");
    }
}

