/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.storage.AnnouncementStorage;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import org.exoplatform.social.core.identity.model.Identity;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AnnouncementStorageTest {
    private static MockedStatic<Utils> UTILS;
    private static MockedStatic<ProgramMapper> DOMAIN_MAPPER;
    @Mock
    private RealizationStorage realizationStorage;
    @Mock
    private RuleStorage ruleStorage;
    private AnnouncementStorage announcementStorage;

    @BeforeClass
    public static void initClassContext() {
        UTILS = Mockito.mockStatic(Utils.class);
        DOMAIN_MAPPER = Mockito.mockStatic(ProgramMapper.class);
    }

    @AfterClass
    public static void cleanClassContext() {
        UTILS.close();
        DOMAIN_MAPPER.close();
    }

    @Before
    public void setUp() throws Exception {
        UTILS.reset();
        DOMAIN_MAPPER.reset();
        UTILS.when(() -> Utils.parseSimpleDate((String)((String)ArgumentMatchers.any()))).thenCallRealMethod();
        UTILS.when(() -> Utils.toSimpleDateFormat((Date)((Date)ArgumentMatchers.any()))).thenCallRealMethod();
        this.announcementStorage = new AnnouncementStorage(this.realizationStorage, this.ruleStorage);
    }

    @Test
    public void testSaveAnnouncement() {
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(System.currentTimeMillis() + 2L);
        RuleDTO rule = new RuleDTO();
        rule.setId(Long.valueOf(1L));
        rule.setTitle("new challenge");
        rule.setDescription("challenge description");
        rule.setStartDate(Utils.toSimpleDateFormat((Date)startDate));
        rule.setEndDate(Utils.toSimpleDateFormat((Date)endDate));
        rule.setScore(10);
        EventDTO event = new EventDTO();
        event.setTitle("gamification");
        event.setTrigger("gamification");
        event.setType("gamification");
        rule.setEvent(event);
        rule.setEnabled(true);
        Date createDate = new Date(System.currentTimeMillis() + 1L);
        Announcement announcement = new Announcement(0L, rule.getId(), rule.getTitle(), Long.valueOf(1L), "announcement comment", Long.valueOf(1L), Utils.toSimpleDateFormat((Date)createDate), null);
        RealizationDTO announcementRealization = new RealizationDTO();
        announcementRealization.setEarnerId(announcement.getAssignee().toString());
        announcementRealization.setEarnerType(IdentityType.USER.name());
        announcementRealization.setCreator(announcement.getCreator());
        announcementRealization.setComment(announcement.getComment());
        announcementRealization.setRuleId(rule.getId());
        announcementRealization.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        RealizationDTO newAnnouncementRealization = new RealizationDTO();
        newAnnouncementRealization.setEarnerId(announcement.getAssignee().toString());
        newAnnouncementRealization.setCreator(announcementRealization.getCreator());
        newAnnouncementRealization.setComment(announcementRealization.getComment());
        newAnnouncementRealization.setRuleId(rule.getId());
        newAnnouncementRealization.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        newAnnouncementRealization.setId(Long.valueOf(1L));
        Announcement announcementRealizationFromEntity = new Announcement();
        announcementRealizationFromEntity.setAssignee(Long.valueOf(newAnnouncementRealization.getEarnerId()));
        announcementRealizationFromEntity.setCreator(newAnnouncementRealization.getCreator());
        announcementRealizationFromEntity.setComment(newAnnouncementRealization.getComment());
        announcementRealizationFromEntity.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        announcementRealizationFromEntity.setChallengeId(newAnnouncementRealization.getRuleId());
        announcementRealizationFromEntity.setId(newAnnouncementRealization.getId().longValue());
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.ruleStorage.findRuleById(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn((Object)rule);
        Mockito.when((Object)this.realizationStorage.createRealization((RealizationDTO)ArgumentMatchers.any())).thenReturn((Object)newAnnouncementRealization);
        UTILS.when(() -> Utils.getIdentityByTypeAndId((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)identity);
        ProgramDTO program = new ProgramDTO();
        program.setTitle("gamification");
        ProgramEntity domainEntity = new ProgramEntity();
        domainEntity.setTitle("gamification");
        DOMAIN_MAPPER.when(() -> ProgramMapper.toEntity((ProgramDTO)program)).thenReturn((Object)domainEntity);
        Announcement createdAnnouncement = this.announcementStorage.createAnnouncement(announcement);
        Assert.assertNotNull((Object)createdAnnouncement);
        Assert.assertEquals((long)1L, (long)createdAnnouncement.getId());
        RealizationDTO realization = new RealizationDTO();
        realization.setEarnerId(announcement.getAssignee().toString());
        realization.setCreator(announcementRealization.getCreator());
        realization.setRuleId(rule.getId());
        realization.setComment(announcementRealization.getComment());
        realization.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        realization.setId(Long.valueOf(1L));
        realization.setActivityId(null);
        realization.setObjectId(null);
        announcementRealizationFromEntity = new Announcement();
        announcementRealizationFromEntity.setAssignee(Long.valueOf(newAnnouncementRealization.getEarnerId()));
        announcementRealizationFromEntity.setCreator(newAnnouncementRealization.getCreator());
        announcementRealizationFromEntity.setComment(newAnnouncementRealization.getComment());
        announcementRealizationFromEntity.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        announcementRealizationFromEntity.setChallengeId(newAnnouncementRealization.getRuleId());
        announcementRealizationFromEntity.setId(newAnnouncementRealization.getId().longValue());
        announcementRealizationFromEntity.setActivityId(null);
        Mockito.when((Object)this.realizationStorage.getRealizationById(newAnnouncementRealization.getId().longValue())).thenReturn((Object)realization);
        Mockito.when((Object)this.realizationStorage.updateRealization((RealizationDTO)ArgumentMatchers.any())).thenReturn((Object)realization);
        Announcement deletedAnnouncement = this.announcementStorage.deleteAnnouncement(announcement.getId());
        Assert.assertNotNull((Object)deletedAnnouncement);
        Assert.assertEquals((long)1L, (long)deletedAnnouncement.getId());
        Assert.assertNull((Object)deletedAnnouncement.getActivityId());
    }

    @Test
    public void testGetAnnouncementById() {
        Date startDate = new Date(System.currentTimeMillis());
        Date endDate = new Date(System.currentTimeMillis() + 1L);
        RuleEntity ruleEntity = new RuleEntity();
        ruleEntity.setDescription("challenge description");
        ruleEntity.setTitle("new challenge");
        ruleEntity.setStartDate(startDate);
        ruleEntity.setEndDate(endDate);
        ruleEntity.setId(Long.valueOf(1L));
        Date createDate = new Date(System.currentTimeMillis());
        RealizationDTO realization = new RealizationDTO();
        realization.setId(Long.valueOf(1L));
        realization.setEarnerId("1");
        realization.setEarnerId("1");
        realization.setCreator(Long.valueOf(1L));
        realization.setRuleId(ruleEntity.getId());
        realization.setComment("announcement comment");
        realization.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        Announcement announcementFromEntity = new Announcement();
        announcementFromEntity.setId(realization.getId().longValue());
        announcementFromEntity.setAssignee(Long.valueOf(realization.getEarnerId()));
        announcementFromEntity.setCreator(realization.getCreator());
        announcementFromEntity.setComment(realization.getComment());
        announcementFromEntity.setCreatedDate(Utils.toSimpleDateFormat((Date)createDate));
        announcementFromEntity.setChallengeId(realization.getRuleId());
        announcementFromEntity.setId(realization.getId().longValue());
        Mockito.when((Object)this.realizationStorage.getRealizationById(ArgumentMatchers.anyLong())).thenReturn((Object)realization);
        Announcement createdAnnouncement = this.announcementStorage.getAnnouncementById(1L);
        Assert.assertNotNull((Object)createdAnnouncement);
        Assert.assertEquals((long)1L, (long)createdAnnouncement.getId());
        Assert.assertEquals((Object)announcementFromEntity, (Object)createdAnnouncement);
    }
}

