/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;

public class ProgramAutoDisableListenerTest
extends AbstractServiceTest {
    public void testDisablePrograms() throws Exception {
        ProgramDTO program = this.newProgram();
        RuleDTO rule = this.newRuleDTO("rule1", program.getId());
        ProgramAutoDisableListenerTest.assertEquals((int)1, (int)this.ruleService.countActiveRules(program.getId()));
        ProgramAutoDisableListenerTest.assertTrue((boolean)program.isEnabled());
        rule.setEndDate(Utils.toSimpleDateFormat((Date)Date.from(LocalDate.now().minusDays(1L).atStartOfDay().toInstant(ZoneOffset.UTC))));
        this.ruleService.updateRule(rule);
        ProgramAutoDisableListenerTest.assertEquals((int)0, (int)this.ruleService.countActiveRules(program.getId()));
        program = this.programService.getProgramById(program.getId());
        ProgramAutoDisableListenerTest.assertFalse((boolean)program.isEnabled());
    }
}

