/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.gamification.utils.Utils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class RuleStorageTest
extends AbstractServiceTest {
    @Test
    public void testSaveRule() {
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)0);
        RuleDTO rule = new RuleDTO();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription("Description");
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setEvent(this.newEventDTO("createNewTask"));
        rule.setCreatedBy("1");
        rule.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule.setLastModifiedBy("1");
        rule.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule.setProgram(this.newProgram());
        rule.setType(EntityType.AUTOMATIC);
        this.ruleStorage.saveRule(rule);
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)1);
    }

    @Test
    public void testFindRuleById() {
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RuleStorageTest.assertEquals((String)this.ruleStorage.findRuleById(rule.getId()).getTitle(), (String)rule.getTitle());
    }

    @Test
    public void testFindRuleByEventAndDomain() {
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        long domainId = rule.getProgram().getId();
        RuleStorageTest.assertEquals((String)this.ruleStorage.findActiveRuleByEventAndProgramId(rule.getEvent().getTitle(), domainId).getTitle(), (String)rule.getTitle());
    }

    @Test
    public void testFindAllRules() {
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)0);
        RuleDTO rule1 = this.newRuleDTO();
        RuleDTO rule2 = this.newRuleDTO();
        RuleDTO rule3 = this.newRuleDTO();
        RuleDTO manualRule = new RuleDTO();
        manualRule.setScore(Integer.parseInt("50"));
        manualRule.setTitle("createNewTask");
        manualRule.setDescription("Description");
        manualRule.setEnabled(true);
        manualRule.setDeleted(false);
        manualRule.setEvent(this.newEventDTO("createNewTask"));
        manualRule.setCreatedBy("1");
        manualRule.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        manualRule.setLastModifiedBy("1");
        manualRule.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        manualRule.setProgram(this.newProgram());
        manualRule.setType(EntityType.MANUAL);
        this.ruleStorage.saveRule(manualRule);
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)4);
    }

    @Test
    public void testDeleteRule() throws ObjectNotFoundException {
        RuleStorageTest.assertEquals((int)this.ruleStorage.findAllRulesIds(0, -1).size(), (int)0);
        RuleDTO rule = this.newRuleDTO();
        RuleStorageTest.assertEquals((String)this.ruleStorage.findRuleById(rule.getId()).getTitle(), (String)rule.getTitle());
        RuleStorageTest.assertFalse((boolean)rule.isDeleted());
        rule.setDeleted(true);
        this.ruleStorage.deleteRuleById(rule.getId().longValue(), "root");
        rule = this.ruleStorage.findRuleById(rule.getId());
        RuleStorageTest.assertTrue((boolean)rule.isDeleted());
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.ruleStorage.deleteRuleById(154L, "root"));
    }

    @Test
    public void testFindRulesIdsByFilter() {
        ProgramDTO domain1 = this.newProgram("domain1");
        ProgramDTO domain2 = this.newProgram("domain2");
        domain2.setSpaceId(2L);
        this.programStorage.saveProgram(domain2);
        RuleFilter filter = new RuleFilter();
        filter.setProgramId(domain1.getId());
        filter.setSpaceIds(Collections.singletonList(domain1.getSpaceId()));
        List rules = this.ruleStorage.findRuleIdsByFilter(filter, 0, 10);
        RuleStorageTest.assertEquals((int)0, (int)rules.size());
        RuleDTO rule1 = new RuleDTO();
        rule1.setScore(Integer.parseInt("50"));
        rule1.setTitle("rule1");
        rule1.setDescription("Description");
        rule1.setEnabled(true);
        rule1.setDeleted(false);
        rule1.setEvent(this.newEventDTO("createNewTask"));
        rule1.setCreatedBy("1");
        rule1.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule1.setLastModifiedBy("1");
        rule1.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule1.setProgram(domain1);
        rule1.setType(EntityType.MANUAL);
        RuleDTO rule2 = new RuleDTO();
        rule2.setScore(Integer.parseInt("50"));
        rule2.setTitle("rule2");
        rule2.setDescription("Description");
        rule2.setEnabled(true);
        rule2.setDeleted(false);
        rule2.setEvent(this.newEventDTO("createNewTask"));
        rule2.setCreatedBy("1");
        rule2.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule2.setLastModifiedBy("1");
        rule2.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule2.setProgram(domain1);
        rule2.setType(EntityType.MANUAL);
        RuleDTO rule3 = new RuleDTO();
        rule3.setScore(Integer.parseInt("50"));
        rule3.setTitle("rule3");
        rule3.setDescription("Description");
        rule3.setEnabled(true);
        rule3.setDeleted(false);
        rule3.setEvent(this.newEventDTO("createNewTask"));
        rule3.setCreatedBy("1");
        rule3.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule3.setLastModifiedBy("1");
        rule3.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule3.setProgram(domain2);
        rule3.setType(EntityType.MANUAL);
        rule1 = this.ruleStorage.saveRule(rule1);
        rule2 = this.ruleStorage.saveRule(rule2);
        rule3 = this.ruleStorage.saveRule(rule3);
        rules = this.ruleStorage.findRuleIdsByFilter(filter, 0, 10);
        RuleStorageTest.assertEquals((int)2, (int)rules.size());
        RuleStorageTest.assertEquals((Object)rule1.getId(), rules.get(0));
        RuleStorageTest.assertEquals((Object)rule2.getId(), rules.get(1));
        filter.setProgramId(domain2.getId());
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        rules = this.ruleStorage.findRuleIdsByFilter(filter, 0, 10);
        RuleStorageTest.assertEquals((int)1, (int)rules.size());
        RuleStorageTest.assertEquals((Object)rule3.getId(), rules.get(0));
        filter.setProgramId(domain1.getId());
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        rules = this.ruleStorage.findRuleIdsByFilter(filter, 0, 10);
        RuleStorageTest.assertEquals((int)0, (int)rules.size());
        filter.setProgramId(0L);
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        rules = this.ruleStorage.findRuleIdsByFilter(filter, 0, 10);
        RuleStorageTest.assertEquals((int)1, (int)rules.size());
        RuleStorageTest.assertEquals((Object)rule3.getId(), rules.get(0));
    }

    @Test
    public void testCountRulesByFilter() {
        ProgramDTO domain1 = this.newProgram("domain1");
        ProgramDTO domain2 = this.newProgram("domain2");
        domain2.setSpaceId(2L);
        this.programStorage.saveProgram(domain2);
        RuleFilter filter = new RuleFilter();
        filter.setProgramId(domain1.getId());
        filter.setSpaceIds(Collections.singletonList(domain1.getSpaceId()));
        RuleStorageTest.assertEquals((int)0, (int)this.ruleStorage.countRulesByFilter(filter));
        RuleDTO rule1 = new RuleDTO();
        rule1.setScore(Integer.parseInt("50"));
        rule1.setTitle("rule1");
        rule1.setDescription("Description");
        rule1.setEnabled(true);
        rule1.setDeleted(false);
        rule1.setEvent(this.newEventDTO("createNewTask"));
        rule1.setCreatedBy("1");
        rule1.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule1.setLastModifiedBy("1");
        rule1.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule1.setProgram(domain1);
        rule1.setType(EntityType.MANUAL);
        RuleDTO rule2 = new RuleDTO();
        rule2.setScore(Integer.parseInt("50"));
        rule2.setTitle("rule2");
        rule2.setDescription("Description");
        rule2.setEnabled(true);
        rule2.setDeleted(false);
        rule2.setEvent(this.newEventDTO("createNewTask"));
        rule2.setCreatedBy("1");
        rule2.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule2.setLastModifiedBy("1");
        rule2.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule2.setProgram(domain1);
        rule2.setType(EntityType.MANUAL);
        RuleDTO rule3 = new RuleDTO();
        rule3.setScore(Integer.parseInt("50"));
        rule3.setTitle("rule3");
        rule3.setDescription("Description");
        rule3.setEnabled(true);
        rule3.setDeleted(false);
        rule3.setEvent(this.newEventDTO("createNewTask"));
        rule3.setCreatedBy("1");
        rule3.setCreatedDate(Utils.toRFC3339Date((Date)new Date()));
        rule3.setLastModifiedBy("1");
        rule3.setLastModifiedDate(Utils.toRFC3339Date((Date)new Date()));
        rule3.setProgram(domain2);
        rule3.setType(EntityType.MANUAL);
        this.ruleStorage.saveRule(rule1);
        this.ruleStorage.saveRule(rule2);
        this.ruleStorage.saveRule(rule3);
        RuleStorageTest.assertEquals((int)2, (int)this.ruleStorage.countRulesByFilter(filter));
        filter.setProgramId(domain2.getId());
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        RuleStorageTest.assertEquals((int)1, (int)this.ruleStorage.countRulesByFilter(filter));
        filter.setProgramId(domain1.getId());
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        RuleStorageTest.assertEquals((int)0, (int)this.ruleStorage.countRulesByFilter(filter));
        filter.setProgramId(0L);
        filter.setSpaceIds(Collections.singletonList(domain2.getSpaceId()));
        RuleStorageTest.assertEquals((int)1, (int)this.ruleStorage.countRulesByFilter(filter));
    }
}

