/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.test;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.dao.BadgeDAO;
import io.meeds.gamification.dao.ConnectorAccountDAO;
import io.meeds.gamification.dao.EventDAO;
import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RealizationDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.entity.EventEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.entity.RealizationEntity;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.rest.BadgeRest;
import io.meeds.gamification.rest.ProgramRest;
import io.meeds.gamification.search.RuleIndexingServiceConnector;
import io.meeds.gamification.service.AnnouncementService;
import io.meeds.gamification.service.BadgeService;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RealizationComputingService;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.service.TriggerService;
import io.meeds.gamification.service.impl.EventRegistryImpl;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.mapper.BadgeMapper;
import io.meeds.gamification.storage.mapper.EventMapper;
import io.meeds.gamification.storage.mapper.ProgramMapper;
import io.meeds.gamification.storage.mapper.RealizationMapper;
import io.meeds.gamification.storage.mapper.RuleMapper;
import io.meeds.gamification.utils.Utils;
import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ProviderBinder;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.tools.ResourceLauncher;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.test.mock.MockPrincipal;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.junit.After;
import org.junit.Before;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/gamification-test-configuration.xml")})
public abstract class AbstractServiceTest
extends BaseExoTestCase {
    public static final String GAMIFICATION_DOMAIN = "TeamWork";
    public static final String RULE_NAME = "createNewTask";
    public static final String BADGE_NAME = "TeamLeader";
    public static final String TEST_SPACE_ID = "150";
    public static final String TEST_SPACE2_ID = "152";
    public static final String TEST_USER_RECEIVER = "10";
    public static final String TEST_USER_EARNER = "1";
    public static final long TEST_USER_EARNER_LONG = 1L;
    public static final String ACTIVITY_ID = "245590";
    public static final String TEST_GLOBAL_SCORE = "245590";
    public static final String TEST_SCORE = "50";
    public static final long MILLIS_IN_A_DAY = 86400000L;
    public static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static final int OFFSET = 0;
    public static final int LIMIT = 3;
    public static final String DESCRIPTION = "Description";
    public static final String PROGRAM_CREATOR = "gamification";
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_ID = "objectId";
    protected IdentityManager identityManager;
    protected RelationshipManager relationshipManager;
    protected ActivityManager activityManager;
    protected EntityManagerService entityManagerService;
    protected BadgeRest manageBadgesEndpoint;
    protected ProgramRest manageDomainsEndpoint;
    protected AnnouncementService announcementService;
    protected RequestHandlerImpl requestHandler;
    protected org.exoplatform.social.core.identity.model.Identity rootIdentity;
    protected ResourceLauncher launcher;
    protected ProviderBinder providerBinder;
    protected ResourceBinder resourceBinder;
    protected BadgeService badgeService;
    protected ProgramService programService;
    protected SecuritySettingService securitySettingService;
    protected RuleService ruleService;
    protected ListenerService listenerService;
    protected RealizationService realizationService;
    protected RealizationComputingService realizationComputingService;
    protected BadgeDAO badgeStorage;
    protected ProgramDAO programDAO;
    protected ProgramStorage programStorage;
    protected FileService fileService;
    protected RuleStorage ruleStorage;
    protected RuleDAO ruleDAO;
    protected RealizationDAO realizationDAO;
    protected ConnectorAccountDAO connectorAccountDAO;
    protected RealizationStorage realizationsStorage;
    protected RuleIndexingServiceConnector ruleIndexingServiceConnector;
    protected ConnectorService connectorService;
    protected ConnectorSettingService connectorSettingService;
    protected EventDAO eventDAO;
    protected EventStorage eventStorage;
    protected EventService eventService;
    protected TriggerService triggerService;
    protected EventRegistryImpl eventRegistry;
    protected SpaceService spaceService;
    protected SpaceTemplateService spaceTemplateService;
    protected SettingService settingService;
    protected CodecInitializer codecInitializer;
    protected IdentityRegistry identityRegistry;
    org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("1");
    protected Date fromDate;
    protected Date toDate;
    protected Date outOfRangeDate;
    protected boolean hubRestricted;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.ruleDAO = (RuleDAO)ExoContainerContext.getService(RuleDAO.class);
        this.realizationDAO = (RealizationDAO)ExoContainerContext.getService(RealizationDAO.class);
        this.connectorAccountDAO = (ConnectorAccountDAO)ExoContainerContext.getService(ConnectorAccountDAO.class);
        this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        this.programStorage = (ProgramStorage)ExoContainerContext.getService(ProgramStorage.class);
        this.fileService = (FileService)ExoContainerContext.getService(FileService.class);
        this.ruleStorage = (RuleStorage)ExoContainerContext.getService(RuleStorage.class);
        this.activityManager = (ActivityManager)ExoContainerContext.getService(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)ExoContainerContext.getService(RelationshipManager.class);
        this.announcementService = (AnnouncementService)ExoContainerContext.getService(AnnouncementService.class);
        this.badgeService = (BadgeService)ExoContainerContext.getService(BadgeService.class);
        this.securitySettingService = (SecuritySettingService)ExoContainerContext.getService(SecuritySettingService.class);
        this.programService = (ProgramService)ExoContainerContext.getService(ProgramService.class);
        this.ruleService = (RuleService)ExoContainerContext.getService(RuleService.class);
        this.listenerService = (ListenerService)ExoContainerContext.getService(ListenerService.class);
        this.realizationService = (RealizationService)ExoContainerContext.getService(RealizationService.class);
        this.realizationComputingService = (RealizationComputingService)ExoContainerContext.getService(RealizationComputingService.class);
        this.entityManagerService = (EntityManagerService)ExoContainerContext.getService(EntityManagerService.class);
        this.manageBadgesEndpoint = (BadgeRest)ExoContainerContext.getService(BadgeRest.class);
        this.manageDomainsEndpoint = (ProgramRest)ExoContainerContext.getService(ProgramRest.class);
        this.rootIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", "root");
        this.badgeStorage = (BadgeDAO)ExoContainerContext.getService(BadgeDAO.class);
        this.programDAO = (ProgramDAO)ExoContainerContext.getService(ProgramDAO.class);
        this.realizationsStorage = (RealizationStorage)ExoContainerContext.getService(RealizationStorage.class);
        this.ruleIndexingServiceConnector = (RuleIndexingServiceConnector)ExoContainerContext.getService(RuleIndexingServiceConnector.class);
        this.connectorSettingService = (ConnectorSettingService)ExoContainerContext.getService(ConnectorSettingService.class);
        this.connectorService = (ConnectorService)ExoContainerContext.getService(ConnectorService.class);
        this.eventDAO = (EventDAO)ExoContainerContext.getService(EventDAO.class);
        this.eventStorage = (EventStorage)ExoContainerContext.getService(EventStorage.class);
        this.eventService = (EventService)ExoContainerContext.getService(EventService.class);
        this.triggerService = (TriggerService)ExoContainerContext.getService(TriggerService.class);
        this.eventRegistry = (EventRegistryImpl)ExoContainerContext.getService(EventRegistryImpl.class);
        this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        this.spaceTemplateService = (SpaceTemplateService)ExoContainerContext.getService(SpaceTemplateService.class);
        this.settingService = (SettingService)ExoContainerContext.getService(SettingService.class);
        this.codecInitializer = (CodecInitializer)ExoContainerContext.getService(CodecInitializer.class);
        this.identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        this.resourceBinder = (ResourceBinder)ExoContainerContext.getService(ResourceBinder.class);
        this.requestHandler = (RequestHandlerImpl)ExoContainerContext.getService(RequestHandlerImpl.class);
        ProviderBinder.setInstance((ProviderBinder)new ProviderBinder());
        this.providerBinder = ProviderBinder.getInstance();
        this.fromDate = new Date(System.currentTimeMillis());
        this.toDate = new Date(this.fromDate.getTime() + 86400000L);
        this.outOfRangeDate = new Date(this.fromDate.getTime() - 172800000L);
        this.resourceBinder.clear();
        ApplicationContextImpl.setCurrent((ApplicationContext)new ApplicationContextImpl(null, null, this.providerBinder, null));
        this.launcher = new ResourceLauncher((RequestHandler)this.requestHandler);
        this.resetUserSession();
        CacheService cacheService = (CacheService)ExoContainerContext.getService(CacheService.class);
        cacheService.getCacheInstance("gamification.rule");
        cacheService.getCacheInstance("gamification.realization");
        cacheService.getCacheInstance("gamification.domain");
        this.begin();
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(DEFAULT_TIMEZONE);
        if (this.hubRestricted) {
            this.restartTransaction();
            this.setOpenHubAccess();
        }
        if (this.realizationDAO != null) {
            this.restartTransaction();
            this.realizationDAO.deleteAll();
            this.badgeStorage.deleteAll();
            this.ruleDAO.deleteAll();
            this.programDAO.deleteAll();
            this.connectorAccountDAO.deleteAll();
            this.eventDAO.deleteAll();
            this.programStorage.clearCache();
            this.ruleStorage.clearCache();
            this.end();
        }
    }

    protected void registry(Class<?> resourceClass) {
        this.resourceBinder.addResource(resourceClass, null);
    }

    protected void resetUserSession() {
        ConversationState.setCurrent(null);
    }

    protected ConversationState startSessionAs(String username) {
        Identity identity = this.registerInternalUser(username);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        return state;
    }

    protected ConversationState startExternalSessionAs(String username) {
        Identity identity = this.registerExternalUser(username);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        return state;
    }

    protected void startSessionAsAdministrator(String user) {
        Identity identity = this.registerAdministratorUser(user);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        this.userIdentity = this.identityManager.getOrCreateIdentity("organization", user);
    }

    protected Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(new MembershipEntry("/platform/administrators")));
        this.identityRegistry.register(identity);
        return identity;
    }

    protected Identity registerExternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/externals")));
        this.identityRegistry.register(identity);
        return identity;
    }

    protected Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(new MembershipEntry("/platform/users")));
        this.identityRegistry.register(identity);
        return identity;
    }

    protected RuleEntity newRule() {
        RuleEntity rule = this.ruleDAO.findRuleByTitle(GAMIFICATION_DOMAIN);
        if (rule == null) {
            rule = new RuleEntity();
            rule.setScore(Integer.parseInt(TEST_SCORE));
            rule.setTitle(RULE_NAME);
            rule.setDescription(DESCRIPTION);
            rule.setEnabled(true);
            rule.setDeleted(false);
            rule.setEventEntity(this.newEvent(RULE_NAME));
            rule.setCreatedBy(TEST_USER_EARNER);
            rule.setCreatedDate(new Date());
            rule.setLastModifiedBy(TEST_USER_EARNER);
            rule.setLastModifiedDate(new Date());
            rule.setDomainEntity(this.newDomain());
            rule.setType(EntityType.AUTOMATIC);
            rule.setDefaultRealizationStatus(RealizationStatus.ACCEPTED);
            rule.setRecurrence(RecurrenceType.NONE);
            rule = (RuleEntity)this.ruleDAO.create((Object)rule);
        }
        return rule;
    }

    protected RuleEntity newRule(String name, long domainId) {
        ProgramEntity domainEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(domainId));
        RuleEntity rule = this.ruleDAO.findActiveRuleByEventAndProgramId(name, domainId);
        if (rule == null) {
            rule = new RuleEntity();
            rule.setScore(Integer.parseInt(TEST_SCORE));
            rule.setTitle(name);
            rule.setDescription(DESCRIPTION);
            rule.setEnabled(true);
            rule.setDeleted(false);
            rule.setEventEntity(this.newEvent(name));
            rule.setCreatedBy(TEST_USER_EARNER);
            rule.setCreatedDate(new Date());
            rule.setLastModifiedBy(TEST_USER_EARNER);
            rule.setLastModifiedDate(new Date());
            rule.setDomainEntity(domainEntity);
            rule.setType(EntityType.AUTOMATIC);
            rule.setDefaultRealizationStatus(RealizationStatus.ACCEPTED);
            rule.setRecurrence(RecurrenceType.NONE);
            rule = (RuleEntity)this.ruleDAO.create((Object)rule);
        }
        return rule;
    }

    protected RuleEntity newManualRule(String name, long domainId) {
        ProgramEntity domainEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(domainId));
        RuleEntity rule = this.ruleDAO.findActiveRuleByEventAndProgramId(name, domainId);
        if (rule == null) {
            rule = new RuleEntity();
            rule.setScore(Integer.parseInt(TEST_SCORE));
            rule.setTitle(name);
            rule.setDescription(DESCRIPTION);
            rule.setEnabled(true);
            rule.setDeleted(false);
            rule.setCreatedBy(TEST_USER_EARNER);
            rule.setCreatedDate(new Date());
            rule.setLastModifiedBy(TEST_USER_EARNER);
            rule.setLastModifiedDate(new Date());
            rule.setDomainEntity(domainEntity);
            rule.setType(EntityType.MANUAL);
            rule.setDefaultRealizationStatus(RealizationStatus.PENDING);
            rule.setRecurrence(RecurrenceType.NONE);
            rule.setEndDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 172800000L))));
            rule.setStartDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 172800000L))));
            rule = (RuleEntity)this.ruleDAO.create((Object)rule);
            this.restartTransaction();
        }
        return rule;
    }

    protected RuleEntity newRule(String name, String domain, Boolean isEnabled) {
        return this.newRule(name, domain, isEnabled, EntityType.AUTOMATIC);
    }

    protected RuleEntity newRule(String name, String domain, Boolean isEnabled, EntityType ruleType) {
        RuleEntity rule = this.ruleDAO.findRuleByTitle(name);
        if (rule == null) {
            rule = new RuleEntity();
            rule.setScore(Integer.parseInt(TEST_SCORE));
            rule.setTitle(name);
            rule.setDescription(DESCRIPTION);
            rule.setEnabled(isEnabled.booleanValue());
            rule.setDeleted(false);
            rule.setEventEntity(this.newEvent(name));
            rule.setCreatedBy(TEST_USER_EARNER);
            rule.setCreatedDate(new Date());
            rule.setLastModifiedBy(TEST_USER_EARNER);
            rule.setLastModifiedDate(new Date());
            rule.setDomainEntity(this.newDomain(domain));
            rule.setType(ruleType);
            rule.setDefaultRealizationStatus(RealizationStatus.ACCEPTED);
            rule.setRecurrence(RecurrenceType.NONE);
            rule.setEndDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() + 172800000L))));
            rule.setStartDate(Utils.parseSimpleDate((String)Utils.toRFC3339Date((Date)new Date(System.currentTimeMillis() - 172800000L))));
            rule = (RuleEntity)this.ruleDAO.create((Object)rule);
        }
        return rule;
    }

    protected ProgramEntity newDomain() {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(GAMIFICATION_DOMAIN);
        domain.setDescription(DESCRIPTION);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(new Date());
        domain.setType(EntityType.AUTOMATIC);
        domain.setCreatedDate(new Date());
        domain.setAudienceId(Long.valueOf(1L));
        HashSet<Long> owners = new HashSet<Long>();
        owners.add(1L);
        domain.setOwners(owners);
        domain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        return domain;
    }

    protected EventEntity newEvent(String name) {
        EventEntity event = new EventEntity();
        event.setTitle(name);
        event.setTrigger(name);
        event.setType("eventType");
        event = (EventEntity)this.eventDAO.create((Object)event);
        return event;
    }

    protected ProgramEntity newDomain(EntityType entityType, String name, boolean status, Set<Long> owners) {
        return this.newDomain(entityType, name, status, owners, 1L);
    }

    protected ProgramEntity newDomain(EntityType entityType, String name, boolean status, Set<Long> owners, Long audienceId) {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(name);
        domain.setDescription(DESCRIPTION);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(status);
        domain.setLastModifiedDate(new Date());
        domain.setType(entityType);
        domain.setCreatedDate(new Date());
        domain.setBudget(20L);
        domain.setCoverFileId(1L);
        domain.setAvatarFileId(2L);
        domain.setAudienceId(audienceId);
        domain.setOwners(owners);
        ProgramEntity createdDomain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        this.restartTransaction();
        return createdDomain;
    }

    protected ProgramDTO newProgram(EntityType entityType, String name, boolean status, Set<Long> owners) {
        return ProgramMapper.fromEntity((RuleDAO)this.ruleDAO, (ProgramEntity)this.newDomain(entityType, name, status, owners));
    }

    protected ProgramEntity newOpenProgram(String name) {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(name);
        domain.setDescription(name);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(new Date());
        domain.setType(EntityType.AUTOMATIC);
        domain.setCreatedDate(new Date());
        domain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        this.restartTransaction();
        return domain;
    }

    protected ProgramEntity newDomain(String name) {
        ProgramEntity domain = new ProgramEntity();
        domain.setTitle(name);
        domain.setDescription(name);
        domain.setCreatedBy(TEST_USER_EARNER);
        domain.setLastModifiedBy(TEST_USER_EARNER);
        domain.setDeleted(false);
        domain.setEnabled(true);
        domain.setLastModifiedDate(new Date());
        domain.setType(EntityType.AUTOMATIC);
        domain.setCreatedDate(new Date());
        domain.setAudienceId(Long.valueOf(1L));
        domain = (ProgramEntity)this.programDAO.create((Object)domain);
        this.programStorage.clearCache();
        this.restartTransaction();
        return domain;
    }

    protected BadgeEntity newBadge(long domainId) {
        ProgramEntity domainEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(domainId));
        BadgeEntity badge = new BadgeEntity();
        badge.setTitle(BADGE_NAME);
        badge.setDescription(DESCRIPTION);
        badge.setNeededScore(10);
        badge.setIconFileId(10245L);
        badge.setEnabled(true);
        badge.setDeleted(false);
        badge.setCreatedBy(TEST_USER_EARNER);
        badge.setCreatedDate(new Date());
        badge.setLastModifiedBy(TEST_USER_EARNER);
        badge.setLastModifiedDate(new Date());
        badge.setDomainEntity(domainEntity);
        badge = (BadgeEntity)this.badgeStorage.create((Object)badge);
        return badge;
    }

    protected BadgeEntity newBadgeWithScore() {
        BadgeEntity badge = new BadgeEntity();
        badge.setTitle(BADGE_NAME);
        badge.setDescription(DESCRIPTION);
        badge.setNeededScore(160);
        badge.setIconFileId(10245L);
        badge.setEnabled(true);
        badge.setDeleted(false);
        badge.setCreatedBy(TEST_USER_EARNER);
        badge.setCreatedDate(new Date());
        badge.setLastModifiedBy(TEST_USER_EARNER);
        badge.setLastModifiedDate(new Date());
        badge.setDomainEntity(this.newDomain());
        badge = (BadgeEntity)this.badgeStorage.create((Object)badge);
        return badge;
    }

    protected BadgeEntity newBadge(String name, long domainId) {
        ProgramEntity domainEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(domainId));
        BadgeEntity badge = new BadgeEntity();
        badge.setTitle(name);
        badge.setDescription(DESCRIPTION);
        badge.setNeededScore(Integer.parseInt("245590"));
        badge.setIconFileId(10245L);
        badge.setEnabled(true);
        badge.setDeleted(false);
        badge.setCreatedBy(TEST_USER_EARNER);
        badge.setCreatedDate(new Date());
        badge.setLastModifiedBy(TEST_USER_EARNER);
        badge.setLastModifiedDate(new Date());
        badge.setDomainEntity(domainEntity);
        badge = (BadgeEntity)this.badgeStorage.create((Object)badge);
        return badge;
    }

    protected RealizationEntity newRealizationEntity(String ruleName, long domainId) {
        return this.newRealizationEntity(ruleName, domainId, false);
    }

    protected RealizationEntity newRealizationEntity(String ruleName, long domainId, boolean manual) {
        RuleEntity rule = manual ? this.newManualRule(ruleName, domainId) : this.newRule(ruleName, domainId);
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(RealizationStatus.ACCEPTED);
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(TEST_USER_EARNER);
        gHistory.setEarnerId(1L);
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(rule.getTitle());
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setObjectType(OBJECT_TYPE);
        gHistory.setCreatedDate(this.fromDate);
        gHistory.setType(rule.getType());
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        this.restartTransaction();
        return gHistory;
    }

    protected RealizationEntity newRealizationByRuleByEarnerId(RuleEntity rule, String earnerId) {
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(RealizationStatus.ACCEPTED);
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(earnerId);
        gHistory.setEarnerId(Long.valueOf(earnerId).longValue());
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(rule.getTitle());
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setCreatedDate(this.fromDate);
        gHistory.setType(EntityType.AUTOMATIC);
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        this.restartTransaction();
        return gHistory;
    }

    protected RealizationEntity newRealizationEntityWithRuleId(String actionTitle, Long ruleId) {
        RuleEntity rule = (RuleEntity)this.ruleDAO.find((Serializable)ruleId);
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(RealizationStatus.ACCEPTED);
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(TEST_USER_EARNER);
        gHistory.setEarnerId(1L);
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(actionTitle);
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setDomainEntity(this.newDomain());
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setCreatedDate(this.fromDate);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setType(rule.getType());
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        return gHistory;
    }

    protected RealizationEntity newRealizationsByStatus(RealizationStatus status) {
        RuleEntity rule = this.newRule();
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(status);
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(TEST_USER_EARNER);
        gHistory.setEarnerId(1L);
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(rule.getTitle());
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setDomainEntity(this.newDomain());
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setCreatedDate(this.fromDate);
        gHistory.setType(rule.getType());
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        return gHistory;
    }

    protected RealizationEntity newRealizationsByEarnerId(String earnerId) {
        RuleEntity rule = this.newRule();
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(RealizationStatus.ACCEPTED);
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(TEST_USER_EARNER);
        gHistory.setEarnerId(Long.valueOf(earnerId).longValue());
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(rule.getTitle());
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setDomainEntity(this.newDomain());
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setCreatedDate(this.fromDate);
        gHistory.setType(rule.getType());
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        return gHistory;
    }

    protected RealizationEntity newRealizationToBeSortedByActionTypeInDateRange(Date createdDate, String actionTitle, Long ruleId) {
        RuleEntity rule = (RuleEntity)this.ruleDAO.find((Serializable)ruleId);
        RealizationEntity gHistory = new RealizationEntity();
        gHistory.setStatus(RealizationStatus.ACCEPTED);
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setDomain(rule.getDomainEntity().getTitle());
        gHistory.setDomainEntity(rule.getDomainEntity());
        gHistory.setReceiver(TEST_USER_EARNER);
        gHistory.setEarnerId(1L);
        gHistory.setEarnerType(IdentityType.USER);
        gHistory.setActionTitle(actionTitle);
        gHistory.setActionScore((long)rule.getScore());
        gHistory.setGlobalScore((long)rule.getScore());
        gHistory.setRuleEntity(rule);
        gHistory.setCreatedBy(PROGRAM_CREATOR);
        gHistory.setDomainEntity(this.newDomain());
        gHistory.setObjectId(OBJECT_ID);
        gHistory.setCreatedDate(createdDate);
        gHistory.setType(rule.getType());
        gHistory = (RealizationEntity)this.realizationDAO.create((Object)gHistory);
        return gHistory;
    }

    protected RealizationDTO newRealizationDTO() {
        ProgramEntity domainEntity = this.newDomain();
        return RealizationMapper.fromEntity((ProgramStorage)this.programStorage, (RealizationEntity)this.newRealizationEntity("rule", domainEntity.getId()));
    }

    protected RuleDTO newRuleDTO() {
        return RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)this.newRule());
    }

    protected RuleDTO newRuleDTO(String name, long domainId) {
        return RuleMapper.fromEntity((ProgramStorage)this.programStorage, (EventStorage)this.eventStorage, (RuleEntity)this.newRule(name, domainId));
    }

    protected ProgramDTO newProgram() {
        return ProgramMapper.fromEntity((RuleDAO)this.ruleDAO, (ProgramEntity)this.newDomain());
    }

    protected EventDTO newEventDTO(String event) {
        return EventMapper.fromEntity((EventEntity)this.newEvent(event));
    }

    protected ProgramDTO newProgram(String name) {
        return ProgramMapper.fromEntity((RuleDAO)this.ruleDAO, (ProgramEntity)this.newDomain(name));
    }

    protected BadgeDTO newBadgeDTO() {
        return BadgeMapper.fromEntity((ProgramStorage)this.programStorage, (BadgeEntity)this.newBadge(1L));
    }

    public boolean isThisDateWithinThisRange(Date date) {
        return !(!date.before(this.toDate) && !date.equals(this.toDate) || !date.after(this.fromDate) && !date.equals(this.fromDate));
    }

    protected void setOpenHubAccess() {
        this.securitySettingService.saveRegistrationType(UserRegistrationType.OPEN);
        this.hubRestricted = false;
    }

    protected void setRestrictedHubAccess() {
        this.securitySettingService.saveRegistrationType(UserRegistrationType.RESTRICTED);
        this.hubRestricted = true;
    }

    protected ContainerResponse getResponse(String method, String restPath, String input) throws Exception {
        byte[] jsonData = (StringUtils.isBlank((CharSequence)input) ? "" : input).getBytes(StandardCharsets.UTF_8);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        headers.putSingle((Object)"content-length", (Object)("" + jsonData.length));
        return this.launcher.service(method, restPath, "", (Map)headers, jsonData, null);
    }

    public String getURLResource(String resourceURL) {
        return "/gamification/" + resourceURL;
    }

    protected static class MockSecurityContext
    implements SecurityContext {
        private final String username;

        public MockSecurityContext(String username) {
            this.username = username;
        }

        public Principal getUserPrincipal() {
            return new MockPrincipal(this.username);
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }
}

