/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.plugin.AnnouncementActivityTypePlugin;
import java.util.HashMap;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnouncementActivityTypePluginTest {
    @Mock
    private ActivityStorage storage;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private UserACL userAclService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private RelationshipManager relationshipManager;

    @Test
    public void testAnnouncementActivityTypePlugin() {
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.getType()).thenReturn((Object)"gamificationActionAnnouncement");
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("realizationStatus", String.valueOf(RealizationStatus.PENDING));
        Mockito.when((Object)activity.getTemplateParams()).thenReturn(templateParams);
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity viewer = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)viewer.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        ActivityManagerImpl activityManager = new ActivityManagerImpl(this.storage, this.identityManager, this.spaceService, this.relationshipManager, this.userAclService, null);
        Assert.assertTrue((boolean)activityManager.isActivityEditable(activity, owner));
        Assert.assertFalse((boolean)activityManager.isActivityEditable(activity, viewer));
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("type");
        valueParam.setValue("gamificationActionAnnouncement");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("enableNotification");
        valueParam.setValue("false");
        initParams.addParameter((Parameter)valueParam);
        activityManager.addActivityTypePlugin((ActivityTypePlugin)new AnnouncementActivityTypePlugin(initParams, this.identityManager));
        Assert.assertTrue((boolean)activityManager.isActivityEditable(activity, owner));
        Assert.assertFalse((boolean)activityManager.isActivityEditable(activity, viewer));
        templateParams = new HashMap();
        templateParams.put("realizationStatus", String.valueOf(RealizationStatus.REJECTED));
        Mockito.when((Object)activity.getTemplateParams()).thenReturn(templateParams);
        Assert.assertFalse((boolean)activityManager.isActivityEditable(activity, owner));
        Assert.assertFalse((boolean)activityManager.isActivityEditable(activity, viewer));
    }
}

