/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage.cached;

import io.meeds.gamification.dao.ProgramDAO;
import io.meeds.gamification.dao.RuleDAO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.storage.EventStorage;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.storage.cached.model.CacheKey;
import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RuleCachedStorage
extends RuleStorage {
    public static final String RULE_CACHE_NAME = "gamification.rule";
    public static final int RULE_ID_CONTEXT = 0;
    public static final int RULE_TITLE_CONTEXT = 1;
    public static final int RULES_BY_FILTER_CONTEXT = 3;
    public static final int RULES_COUNT_BY_FILTER_CONTEXT = 4;
    private static final Log LOG = ExoLogger.getLogger(RuleCachedStorage.class);
    private ExoCache<Serializable, Object> ruleCache;
    private FutureExoCache<Serializable, Object, CacheKey> ruleFutureCache;

    public RuleCachedStorage(ProgramStorage programStorage, EventStorage eventStorage, ProgramDAO programDAO, RuleDAO ruleDAO, CacheService cacheService) {
        super(programStorage, eventStorage, programDAO, ruleDAO);
        this.ruleCache = cacheService.getCacheInstance(RULE_CACHE_NAME);
        this.ruleFutureCache = new FutureExoCache((Loader)new Loader<Serializable, Object, CacheKey>(){

            public Object retrieve(CacheKey context, Serializable key) throws Exception {
                if (context.getContext() == 0) {
                    RuleDTO rule = RuleCachedStorage.super.findRuleById(context.getId());
                    if (rule != null) {
                        rule.setCacheTime(System.currentTimeMillis());
                    }
                    return rule;
                }
                if (context.getContext() == 1) {
                    return RuleCachedStorage.super.findRuleByTitle(context.getTitle());
                }
                if (context.getContext() == 3) {
                    return RuleCachedStorage.super.findRuleIdsByFilter(context.getRuleFilter(), context.getOffset(), context.getLimit());
                }
                if (context.getContext() == 4) {
                    return RuleCachedStorage.super.countRulesByFilter(context.getRuleFilter());
                }
                throw new IllegalStateException("Unknown context id " + String.valueOf(context));
            }
        }, this.ruleCache);
    }

    @Override
    public List<Long> findRuleIdsByFilter(RuleFilter ruleFilter, int offset, int limit) {
        CacheKey key = new CacheKey((Integer)3, ruleFilter, offset, limit);
        return (List)this.ruleFutureCache.get((Object)key, (Object)key);
    }

    @Override
    public int countRulesByFilter(RuleFilter ruleFilter) {
        CacheKey key = new CacheKey((Integer)4, ruleFilter);
        return (Integer)this.ruleFutureCache.get((Object)key, (Object)key);
    }

    @Override
    public RuleDTO saveRule(RuleDTO ruleDTO) {
        RuleDTO oldRule = ruleDTO.getId() == null ? null : this.findRuleById(ruleDTO.getId());
        RuleDTO rule = super.saveRule(ruleDTO);
        if (oldRule != null) {
            this.clearCache(oldRule);
        }
        this.clearCache(rule);
        return rule;
    }

    @Override
    public RuleDTO findRuleById(Long id) {
        CacheKey key = new CacheKey((Integer)0, id);
        RuleDTO ruleDTO = (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
        return ruleDTO == null ? null : ruleDTO.clone();
    }

    @Override
    public RuleDTO findRuleByTitle(String title) {
        CacheKey key = new CacheKey((Integer)1, title);
        RuleDTO ruleDTO = (RuleDTO)this.ruleFutureCache.get((Object)key, (Object)key.hashCode());
        return ruleDTO == null ? null : ruleDTO.clone();
    }

    @Override
    public RuleDTO deleteRuleById(long ruleId, String userId) throws ObjectNotFoundException {
        RuleDTO rule = super.deleteRuleById(ruleId, userId);
        this.clearCache(rule);
        return rule;
    }

    @Override
    public void clearCache() {
        this.ruleFutureCache.clear();
    }

    @Override
    public void clearCache(RuleDTO rule) {
        if (rule != null) {
            this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)0, rule.getId()).hashCode()));
            this.ruleFutureCache.remove((Serializable)Integer.valueOf(new CacheKey((Integer)1, rule.getTitle()).hashCode()));
        }
        this.clearListCache();
    }

    @Override
    public void clearListCache() {
        try {
            this.ruleCache.select((CachedObjectSelector)new CachedObjectSelector<Serializable, Object>(this){

                public boolean select(Serializable key, ObjectCacheInfo<? extends Object> ocinfo) {
                    CacheKey cacheKey;
                    return key instanceof CacheKey && ((cacheKey = (CacheKey)key).getContext() == 3 || cacheKey.getContext() == 4);
                }

                public void onSelect(ExoCache<? extends Serializable, ? extends Object> cache, Serializable key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                    cache.remove(key);
                }
            });
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while fine cache clearing, clear all gamification rule cache entries", (Throwable)e);
            this.ruleCache.clearCache();
        }
    }
}

