/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.response.ControllerResponse;

abstract class RequestHandler<T extends ControllerRequest> {
    protected static final Log log = ExoLogger.getLogger(RequestHandler.class);
    protected PortletController controller;
    protected final Class<T> t;

    protected RequestHandler(Class<T> t, PortletController controller) {
        this.t = t;
        this.controller = controller;
    }

    public ControllerResponse handle(ControllerContext controllerContext, ControllerRequest request) throws PortletInvokerException {
        if (!this.t.isInstance(request)) {
            throw new IllegalArgumentException("Request " + String.valueOf(request) + " cannot be handled by this handler");
        }
        ControllerRequest req = (ControllerRequest)this.t.cast(request);
        PortletInvocationResponse response = req.invoke(controllerContext);
        return this.processResponse(controllerContext, req, response);
    }

    abstract ControllerResponse processResponse(ControllerContext var1, T var2, PortletInvocationResponse var3) throws PortletInvokerException;
}

