/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.StateString;
import org.gatein.pc.controller.request.PortletActionRequest;
import org.gatein.pc.controller.request.PortletRenderRequest;
import org.gatein.pc.controller.request.PortletResourceRequest;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;

public class PortletControllerRequestConstructorTestCase
extends TestCase {
    private String windowId = "foo";
    private StateString interactionState = new OpaqueStateString("");
    private StateString resourceState = new OpaqueStateString("");
    private ParameterMap body = new ParameterMap();
    private WindowNavigationalState windowNS = new WindowNavigationalState();
    private PageNavigationalState pageNS = new PageNavigationalState(false);
    private Map<String, String[]> pageNSChanges = Collections.emptyMap();

    public void testWithNonNullArgs() {
        new PortletActionRequest(this.windowId, this.interactionState, (Map)this.body, this.windowNS, this.pageNS);
        new PortletRenderRequest(this.windowId, this.windowNS, this.pageNSChanges, this.pageNS);
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
    }

    public void testWithNullWindowNavigationalState() {
        new PortletActionRequest(this.windowId, this.interactionState, (Map)this.body, null, this.pageNS);
        new PortletRenderRequest(this.windowId, null, this.pageNSChanges, this.pageNS);
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(null, this.pageNS));
    }

    public void testNullPageNavigationalState() {
        new PortletActionRequest(this.windowId, this.interactionState, (Map)this.body, this.windowNS, null);
        new PortletRenderRequest(this.windowId, this.windowNS, this.pageNSChanges, null);
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, null));
    }

    public void testWithNullBody() {
        new PortletActionRequest(this.windowId, this.interactionState, null, this.windowNS, this.pageNS);
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, null, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, null, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
        new PortletResourceRequest(this.windowId, "foo", this.resourceState, null, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
    }

    public void testWithNullResourceId() {
        new PortletResourceRequest(this.windowId, null, this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        new PortletResourceRequest(this.windowId, null, this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
        new PortletResourceRequest(this.windowId, null, this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
    }

    public void testNullWindowId() {
        try {
            new PortletActionRequest(null, this.interactionState, (Map)this.body, this.windowNS, this.pageNS);
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletRenderRequest(null, this.windowNS, this.pageNSChanges, this.pageNS);
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletResourceRequest(null, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletResourceRequest(null, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletResourceRequest(null, "foo", this.resourceState, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullInteractionState() {
        try {
            new PortletActionRequest(this.windowId, null, (Map)this.body, this.windowNS, this.pageNS);
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullResourceState() {
        try {
            new PortletResourceRequest(this.windowId, "foo", null, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletResourceRequest(this.windowId, "foo", null, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PortletResourceRequest(this.windowId, "foo", null, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullScope() {
        try {
            new PortletResourceRequest(this.windowId, "foo", this.resourceState, (Map)this.body, null);
            PortletControllerRequestConstructorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

