/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import jakarta.servlet.http.Cookie;
import java.util.List;
import java.util.Map;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.PortletRequestHandler;
import org.gatein.pc.controller.PortletResourceRequestHandler;
import org.gatein.pc.controller.RequestHandler;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletRequest;
import org.gatein.pc.controller.request.PortletResourceRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;

public class PortletController {
    private boolean distributeNonConsumableEvents = true;
    private boolean distributeNonProduceableEvents = true;
    private int producedEventThreshold = 32;
    private int consumedEventThreshold = 64;

    public boolean getDistributeNonConsumableEvents() {
        return this.distributeNonConsumableEvents;
    }

    public void setDistributeNonConsumableEvents(boolean distributeNonConsumableEvents) {
        this.distributeNonConsumableEvents = distributeNonConsumableEvents;
    }

    public boolean getDistributeNonProduceableEvents() {
        return this.distributeNonProduceableEvents;
    }

    public void setDistributeNonProduceableEvents(boolean distributeNonProduceableEvents) {
        this.distributeNonProduceableEvents = distributeNonProduceableEvents;
    }

    public int getProducedEventThreshold() {
        return this.producedEventThreshold;
    }

    public void setProducedEventThreshold(int producedEventThreshold) {
        this.producedEventThreshold = producedEventThreshold;
    }

    public int getConsumedEventThreshold() {
        return this.consumedEventThreshold;
    }

    public void setConsumedEventThreshold(int consumedEventThreshold) {
        this.consumedEventThreshold = consumedEventThreshold;
    }

    public ControllerResponse process(ControllerContext controllerContext, ControllerRequest controllerRequest) throws PortletInvokerException {
        RequestHandler handler;
        if (controllerContext == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (controllerRequest == null) {
            throw new IllegalArgumentException("Null request");
        }
        if (controllerRequest instanceof PortletRequest) {
            handler = new PortletRequestHandler(this);
        } else if (controllerRequest instanceof PortletResourceRequest) {
            handler = new PortletResourceRequestHandler(this);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + controllerRequest.getClass().getName());
        }
        return handler.handle(controllerContext, controllerRequest);
    }

    public PortletInvocationResponse render(ControllerContext controllerContext, List<Cookie> cookies, PageNavigationalState pageNavigationalState, String windowId) throws PortletInvokerException {
        WindowNavigationalState windowNS = null;
        if (pageNavigationalState != null) {
            windowNS = pageNavigationalState.getWindowNavigationalState(windowId);
        }
        Map<String, String[]> publicNS = null;
        if (pageNavigationalState != null) {
            publicNS = controllerContext.getStateControllerContext().getPublicWindowNavigationalState(controllerContext, pageNavigationalState, windowId);
        }
        Mode mode = Mode.VIEW;
        WindowState windowState = WindowState.NORMAL;
        StateString portletNS = null;
        if (windowNS != null) {
            if (windowNS.getMode() != null) {
                mode = windowNS.getMode();
            }
            if (windowNS.getWindowState() != null) {
                windowState = windowNS.getWindowState();
            }
            if (windowNS.getPortletNavigationalState() != null) {
                portletNS = windowNS.getPortletNavigationalState();
            }
        }
        PortletInvocationContext renderContext = controllerContext.createPortletInvocationContext(windowId, pageNavigationalState);
        RenderInvocation render = new RenderInvocation(renderContext);
        render.setMode(mode);
        render.setWindowState(windowState);
        render.setNavigationalState(portletNS);
        render.setPublicNavigationalState(publicNS);
        return controllerContext.invoke(windowId, cookies, render);
    }
}

