/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.embed;

import java.util.HashMap;
import java.util.Map;

/**/
class Query extends Chunk
{

   /** . */
   final Map<String, String[]> parameters;

   Query(Map<String, String[]> parameters)
   {
      this.parameters = parameters;
   }

   Query()
   {
      this(new HashMap<String, String[]>());
   }

   Chunk put(String key, String value)
   {
      parameters.put(key, new String[]{value});
      return this;
   }

   @Override
   protected void writeTo(StringBuilder sb, String amp)
   {
      if (parameters.size() > 0)
      {
         String previous = "?";
         for (Map.Entry<String, String[]> parameter : parameters.entrySet())
         {
            String name = parameter.getKey();
            for (String value : parameter.getValue())
            {
               sb.append(previous);
               encode(sb, name, QUERY_PARAM);
               sb.append('=');
               encode(sb, value, QUERY_PARAM);
               previous = amp;
            }
         }
      }
   }
}
