/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr286.api.portleturl;

import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

import static org.gatein.pc.test.unit.Assert.assertEquals;

@TestCase(Assertion.API286_BASE_URL_4)
public class ParameterMap
{
   public ParameterMap(PortletTestCase seq)
   {
      seq.bindAction(0, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            PortletURL url = response.createActionURL();

            // Set parameter
            url.setParameter("foo", "bar");

            // Clear parameters
            Map<String, String[]> map = url.getParameterMap();

            // Check expected entry
            String[] bar1 = map.get("foo");
            assertEquals(1, bar1.length);
            assertEquals("bar", bar1[0]);

            // Check that the entry we had a copy of the value
            url.setParameter("foo", "juu");
            assertEquals("bar", bar1[0]);

            //
            map.clear();

            // Invoker with the no parameter URL
            return new InvokeGetResponse(url.toString());
         }
      });
      seq.bindAction(1, UTP1.ACTION_JOIN_POINT, new PortletActionTestAction()
      {
         @Override
         protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException
         {
            // It should be empty
            assertEquals(Collections.<Object, Object>emptyMap(), request.getParameterMap());
         }
      });
      seq.bindAction(1, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            PortletURL url = response.createRenderURL();

            // Set parameter
            url.setParameter("foo", "bar");

            // Clear parameters
            Map<String, String[]> map = url.getParameterMap();

            // Check expected entry
            String[] bar1 = map.get("foo");
            assertEquals(1, bar1.length);
            assertEquals("bar", bar1[0]);

            // Check that the entry we had a copy of the value
            url.setParameter("foo", "juu");
            assertEquals("bar", bar1[0]);

            //
            map.clear();

            // Invoker with the no parameter URL
            return new InvokeGetResponse(url.toString());
         }
      });
      seq.bindAction(2, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException
         {
            // It should be empty
            assertEquals(Collections.<Object, Object>emptyMap(), request.getParameterMap());

            // Done
            return new EndTestResponse();
         }
      });
   }
}
