/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.tomcat;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.tomcat.ServletAccess;

public class ServletAccessValve
extends ValveBase {
    private static final Log log = ExoLogger.getLogger(ServletAccessValve.class);

    public void invoke(Request request, Response response) throws IOException, ServletException {
        ServletAccess.setRequestAndResponse((HttpServletRequest)request, (HttpServletResponse)response);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Current HttpServletRequest and HttpServletResponse added to ThreadLocal.");
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            ServletAccess.resetRequestAndResponse();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cleaning ThreadLocal");
            }
        }
    }
}

