/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.service;

import io.meeds.ide.model.Widget;
import io.meeds.ide.storage.WidgetStorage;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.portal.navigation.service.NavigationConfigurationService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StaticResourceService {
    public static final String SITE_NAME = "siteName";
    public static final String POSITION = "position";
    public static final String ENABLED = "enabled";
    public static final String CONTENT_ID = "ide/WidgetPortlet";
    public static final String WIDGET_ID = "widgetId";
    private static final String SPACE_SITE_TYPE_PREFIX = "/spaces/";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private WidgetStorage widgetStorage;
    @Autowired
    private UserPortalConfigService userPortalConfigService;
    private NavigationConfigurationService navigationConfigurationService;

    public List<Widget> getStaticResources(String siteName, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't an administrator");
        }
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put(SITE_NAME, siteName);
        return this.widgetStorage.getWidgetsByProperties(filters);
    }

    public List<Application> getStaticResourceApplications(String siteName, String applicationPosition) {
        ArrayList<Application> applications = new ArrayList<Application>(this.getApplicationsBySite(siteName, applicationPosition));
        if (!StringUtils.equals((CharSequence)this.userPortalConfigService.getMetaPortal(), (CharSequence)siteName) && (this.getNavigationConfigurationService().isMetaSiteNavigation(siteName) || siteName.startsWith(SPACE_SITE_TYPE_PREFIX))) {
            applications.addAll(this.getApplicationsBySite(this.userPortalConfigService.getMetaPortal(), applicationPosition));
        }
        return applications;
    }

    public Widget createStaticResource(Widget widget, String username) throws IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't an administrator");
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        long userId = Long.parseLong(identity.getId());
        widget.setCreatorId(userId);
        widget.setModifierId(userId);
        widget.setCreatedDate(LocalDateTime.now());
        widget.setModifiedDate(LocalDateTime.now());
        Widget createdWidget = this.widgetStorage.createWidget(widget);
        this.listenerService.broadcast("ide.widget.created", null, (Object)createdWidget);
        return createdWidget;
    }

    private List<Application> getApplicationsBySite(String siteName, String applicationPosition) {
        return this.getWidgetsBySite(siteName, applicationPosition).stream().map(this::toApplication).toList();
    }

    private List<Widget> getWidgetsBySite(String siteName, String applicationPosition) {
        Map<String, String> filters = this.createFilters(siteName, applicationPosition);
        ArrayList<Widget> widgets = new ArrayList<Widget>(this.widgetStorage.getWidgetsByProperties(filters));
        if ("END_OF_BODY".equals(applicationPosition)) {
            filters.put(POSITION, "");
            widgets.addAll(this.widgetStorage.getWidgetsByProperties(filters));
        }
        return widgets;
    }

    private Map<String, String> createFilters(String siteName, String applicationPosition) {
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put(SITE_NAME, siteName);
        filters.put(POSITION, applicationPosition);
        filters.put(ENABLED, "true");
        return filters;
    }

    private Application toApplication(Widget widget) {
        Application app = Application.createPortletApplication();
        app.setState((ApplicationState)new TransientApplicationState(CONTENT_ID, new PortletBuilder().add(WIDGET_ID, String.valueOf(widget.getId())).build()));
        app.setStorageId(String.valueOf(widget.getId()));
        return app;
    }

    private NavigationConfigurationService getNavigationConfigurationService() {
        if (this.navigationConfigurationService == null) {
            this.navigationConfigurationService = (NavigationConfigurationService)CommonsUtils.getService(NavigationConfigurationService.class);
        }
        return this.navigationConfigurationService;
    }
}

