/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.plugin.renderer;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.WidgetService;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.StreamSupport;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.springframework.stereotype.Service;

@Service
public class WidgetPortletInstancePreferencePlugin
implements PortletInstancePreferencePlugin {
    private static final String WIDGET_ID_PARAM = "widgetId";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    private final WidgetService widgetService;

    public WidgetPortletInstancePreferencePlugin(WidgetService widgetService) {
        this.widgetService = widgetService;
    }

    public String getPortletName() {
        return "WidgetPortlet";
    }

    public List<PortletInstancePreference> generatePreferences(Application application, Portlet preferences, PortletInstanceContext portletInstanceContext) {
        if (portletInstanceContext != null && portletInstanceContext.isExport()) {
            if (preferences != null && preferences.getPreference(DATA_INIT_PREFERENCE_NAME) != null && preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue() != null) {
                return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue()));
            }
            long widgetId = 0L;
            if (preferences != null) {
                widgetId = Long.parseLong(preferences.getPreference(WIDGET_ID_PARAM).getValue());
            }
            Widget widget = this.widgetService.getWidget(widgetId);
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("html", widget.getHtml());
            content.put("js", widget.getJs());
            content.put("css", widget.getCss());
            return List.of(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, JsonUtils.toJsonString(content)), new PortletInstancePreference(WIDGET_ID_PARAM, String.valueOf(widget.getId())));
        }
        return StreamSupport.stream(preferences.spliterator(), false).map(p -> new PortletInstancePreference(p.getName(), p.getValue())).toList();
    }
}

