/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.storage;

import io.meeds.ide.dao.WidgetDAO;
import io.meeds.ide.entity.WidgetEntity;
import io.meeds.ide.model.Widget;
import io.meeds.ide.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class WidgetStorage {
    private static final String CACHE_NAME = "ide.widget";
    @Autowired
    private WidgetDAO widgetDAO;

    @Cacheable(value={"ide.widget"})
    public Widget getWidget(Long id) {
        return this.widgetDAO.findById(id).map(Utils::fromEntity).orElse(null);
    }

    public Widget createWidget(Widget widget) {
        widget.setId(null);
        WidgetEntity widgetEntity = Utils.toEntity(widget);
        widgetEntity = (WidgetEntity)this.widgetDAO.save(widgetEntity);
        return Utils.fromEntity(widgetEntity);
    }

    @CacheEvict(value={"ide.widget"}, key="#p0.id")
    public Widget updateWidget(Widget widget) {
        WidgetEntity widgetEntity = Utils.toEntity(widget);
        widgetEntity = (WidgetEntity)this.widgetDAO.save(widgetEntity);
        return Utils.fromEntity(widgetEntity);
    }

    public Widget getWidgetByPortletId(long portletInstanceId) {
        WidgetEntity widgetEntity = this.widgetDAO.findByPortletId(portletInstanceId);
        return widgetEntity == null ? null : Utils.fromEntity(widgetEntity);
    }

    public boolean existsByPortletInstanceId(Long portletInstanceId) {
        return this.widgetDAO.existsByPortletId(portletInstanceId);
    }
}

