/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.ide.model.Widget;
import io.meeds.ide.rest.WidgetRest;
import io.meeds.ide.service.WidgetService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={WidgetRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class WidgetRestTest {
    private static final String REST_PATH = "/widgets";
    private static final String HTML_CONTENT = "...html...";
    private static final String CSS_CONTENT = "...css...";
    private static final String JS_CONTENT = "...js...";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private WidgetService widgetService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @Mock
    private Widget widget;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    RequestPostProcessor testAdministrator() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    @Test
    void getWidgetAnonymouslyWhenNotFound() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getWidgetAnonymously() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenReturn((Object)this.widget);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getWidgetHtmlAnonymouslyWhenNotFound() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/html", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getWidgetHtmlAnonymously() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenReturn((Object)this.widget);
        Mockito.when((Object)this.widget.getHtml()).thenReturn((Object)HTML_CONTENT);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/html", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(HTML_CONTENT)).andExpect(MockMvcResultMatchers.header().string("Content-Type", MediaType.TEXT_HTML.toString()));
    }

    @Test
    void getWidgetCssAnonymouslyWhenNotFound() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/css", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getWidgetCssAnonymously() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenReturn((Object)this.widget);
        Mockito.when((Object)this.widget.getCss()).thenReturn((Object)CSS_CONTENT);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/css", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(CSS_CONTENT)).andExpect(MockMvcResultMatchers.header().string("Content-Type", "text/css"));
    }

    @Test
    void getWidgetJsAnonymouslyWhenNotFound() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/js", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void getWidgetJsAnonymously() throws Exception {
        Mockito.when((Object)this.widgetService.getWidget(2L)).thenReturn((Object)this.widget);
        Mockito.when((Object)this.widget.getJs()).thenReturn((Object)JS_CONTENT);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/widgets/2/js", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("(function() {...js...})()")).andExpect(MockMvcResultMatchers.header().string("Content-Type", "text/javascript"));
    }

    @Test
    void updateWidgetAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/widgets/1", (Object[])new Object[0]).content(this.asJsonString(this.widget)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.widgetService});
    }

    @Test
    void updateWidgetWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/widgets/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(this.asJsonString(this.widget)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.widgetService});
    }

    @Test
    void updateWidgetWithAdministrator() throws Exception {
        Widget widgetToUpdate = new Widget();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()).content(this.asJsonString(widgetToUpdate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        widgetToUpdate.setId(Long.valueOf(1L));
        ((WidgetService)Mockito.verify((Object)this.widgetService)).updateWidget(widgetToUpdate, SIMPLE_USER);
    }

    @Test
    void updateWidgetWithAdministratorNotFound() throws Exception {
        Mockito.when((Object)this.widgetService.updateWidget((Widget)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()).content(this.asJsonString(this.widget)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void updateWidgetWithAdministratorForbidden() throws Exception {
        Mockito.when((Object)this.widgetService.updateWidget((Widget)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()).content(this.asJsonString(this.widget)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWidgetAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/widgets/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWidgetWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/widgets/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteWidgetWithAdministrator() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((WidgetService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Widget with id 1 doesn't exists")}).when((Object)this.widgetService)).deleteWidget(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((WidgetService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)this.widgetService)).deleteWidget(1L, SIMPLE_USER);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/widgets/1", (Object[])new Object[0]).with(this.testAdministrator()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

