/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.service;

import io.meeds.ide.constant.WidgetType;
import io.meeds.ide.model.Widget;
import io.meeds.ide.storage.WidgetStorage;
import io.meeds.layout.service.LayoutAclService;
import java.time.LocalDateTime;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WidgetService {
    public static final String IDE_WIDGET_CREATED_EVENT = "ide.widget.created";
    public static final String IDE_WIDGET_UPDATED_EVENT = "ide.widget.updated";
    public static final String NOT_ADMINISTRATOR_USER = "User isn't an administrator";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private WidgetStorage widgetStorage;

    public Widget getWidget(long id) throws ObjectNotFoundException {
        Widget widget = this.widgetStorage.getWidget(id);
        if (widget == null) {
            throw new ObjectNotFoundException(String.format("Widget with id %s doesn't exists", id));
        }
        return widget;
    }

    public Widget getWidgetByPortletId(long portletInstanceId) {
        return this.widgetStorage.getWidgetByPortletId(portletInstanceId);
    }

    public Widget createWidget(Widget widget, String username) throws ObjectAlreadyExistsException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException(NOT_ADMINISTRATOR_USER);
        }
        if (widget.getPortletId() == null || widget.getPortletId() == 0L) {
            throw new IllegalArgumentException("Widget portlet instance id is mandatory");
        }
        if (this.widgetStorage.existsByPortletInstanceId(widget.getPortletId())) {
            throw new ObjectAlreadyExistsException((Object)String.format("Widget for portlet with id %s already exists", widget.getPortletId()));
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        widget.setCreatorId(Long.parseLong(identity.getId()));
        widget.setModifierId(Long.parseLong(identity.getId()));
        widget.setCreatedDate(LocalDateTime.now());
        widget.setModifiedDate(LocalDateTime.now());
        widget.setType(WidgetType.APP);
        Widget createdWidget = this.widgetStorage.createWidget(widget);
        this.listenerService.broadcast(IDE_WIDGET_CREATED_EVENT, null, (Object)createdWidget);
        return createdWidget;
    }

    public Widget updateWidget(Widget widget, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException(NOT_ADMINISTRATOR_USER);
        }
        Widget existingWidget = this.widgetStorage.getWidget(widget.getId());
        if (existingWidget == null) {
            throw new ObjectNotFoundException(String.format("Widget with id %s doesn't exists", widget.getId()));
        }
        Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        existingWidget.setHtml(widget.getHtml());
        existingWidget.setCss(widget.getCss());
        existingWidget.setJs(widget.getJs());
        existingWidget.setProperties(widget.getProperties());
        existingWidget.setModifierId(Long.parseLong(identity.getId()));
        existingWidget.setModifiedDate(LocalDateTime.now());
        Widget updatedWidget = this.widgetStorage.updateWidget(existingWidget);
        this.listenerService.broadcast(IDE_WIDGET_UPDATED_EVENT, null, (Object)updatedWidget);
        return updatedWidget;
    }

    public void deleteWidget(long widgetId, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException(NOT_ADMINISTRATOR_USER);
        }
        this.widgetStorage.deleteWidgetById(widgetId);
    }
}

