/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.ide.constant.WidgetType;
import io.meeds.ide.listener.StaticResourcesAnalyticsListener;
import io.meeds.ide.model.Widget;
import java.util.HashMap;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest(classes={StaticResourcesAnalyticsListener.class})
@TestPropertySource(properties={"spring.profiles.active=layout"})
class StaticResourcesAnalyticsListenerTest {
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private Event<String, Widget> event;
    @Mock
    private Widget widget;
    @Autowired
    private StaticResourcesAnalyticsListener listener;

    StaticResourcesAnalyticsListenerTest() {
    }

    @Test
    void onEvent() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(AnalyticsUtils.class);){
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("siteName", "siteName");
            Mockito.when((Object)this.widget.getProperties()).thenReturn(params);
            Mockito.when((Object)this.widget.getType()).thenReturn((Object)WidgetType.APP);
            Mockito.when((Object)this.widget.getCreatorId()).thenReturn((Object)1L);
            Mockito.when((Object)((Widget)this.event.getData())).thenReturn((Object)this.widget);
            this.listener.onEvent(this.event);
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatisticData.class);
            mockedStatic.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)Mockito.argThat(statisticData -> {
                Assertions.assertEquals((Object)"portal", (Object)statisticData.getModule());
                Assertions.assertEquals((Object)"layout", (Object)statisticData.getSubModule());
                Assertions.assertEquals((Object)"addStatisticResource", (Object)statisticData.getOperation());
                Assertions.assertEquals((Object)"siteName", statisticData.getParameters().get("siteName"));
                Assertions.assertEquals((Object)"APP", statisticData.getParameters().get("type"));
                Assertions.assertEquals((long)1L, (long)statisticData.getUserId());
                return true;
            }))), Mockito.times((int)1));
            AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)captor.capture()));
        }
    }
}

