/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.plugin.renderer;

import io.meeds.ide.model.Widget;
import io.meeds.ide.plugin.renderer.WidgetPortletInstancePreferencePlugin;
import io.meeds.ide.service.WidgetService;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WidgetPortletInstancePreferencePlugin.class})
@ExtendWith(value={MockitoExtension.class})
class WidgetPortletInstancePreferencePluginTest {
    private static final String DATA_PREF_NAME = "data.init";
    private static final String WIDGET_ID_PREF_NAME = "widgetId";
    private static final String SETTING_NAME = "name";
    @MockBean
    private WidgetService widgetService;
    @Autowired
    private WidgetPortletInstancePreferencePlugin widgetPortletInstancePreferencePlugin;

    WidgetPortletInstancePreferencePluginTest() {
    }

    @Test
    void getPortletName() {
        Assertions.assertEquals((Object)"WidgetPortlet", (Object)this.widgetPortletInstancePreferencePlugin.getPortletName());
    }

    @Test
    void generatePreferences() throws ObjectNotFoundException {
        HashMap<String, Preference> map = new HashMap<String, Preference>();
        map.put(DATA_PREF_NAME, new Preference(SETTING_NAME, "value", false));
        map.remove(DATA_PREF_NAME);
        map.put(WIDGET_ID_PREF_NAME, new Preference(SETTING_NAME, "1", false));
        Widget widget = new Widget();
        widget.setJs("Js");
        widget.setHtml("Html");
        widget.setCss("Css");
        Mockito.when((Object)this.widgetService.getWidget(1L)).thenReturn((Object)widget);
        Portlet preferences = new Portlet(map);
        List generatedPreferences = this.widgetPortletInstancePreferencePlugin.generatePreferences(null, preferences, new PortletInstanceContext(false, null));
        Assertions.assertNotNull((Object)generatedPreferences);
        Assertions.assertEquals((int)1, (int)generatedPreferences.size());
        Assertions.assertEquals((Object)SETTING_NAME, (Object)((PortletInstancePreference)generatedPreferences.getFirst()).getName());
        generatedPreferences = this.widgetPortletInstancePreferencePlugin.generatePreferences(null, preferences, new PortletInstanceContext(true, null));
        Assertions.assertNotNull((Object)generatedPreferences);
        Assertions.assertEquals((int)2, (int)generatedPreferences.size());
        Assertions.assertEquals((Object)DATA_PREF_NAME, (Object)((PortletInstancePreference)generatedPreferences.getFirst()).getName());
    }
}

