/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.portlet;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.WidgetService;
import io.meeds.social.portlet.CMSPortlet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.webui.Utils;

public class WidgetPortlet
extends CMSPortlet {
    private static final String OBJECT_TYPE = "widget";
    private static final String WIDGET_ID_PARAM = "widgetId";
    private static final String PORTLET_INSTANCE_ID_PARAM = "portletInstanceId";
    private String editDispatchedPath;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.editDispatchedPath = config.getInitParameter("portlet-edit-dispatched-file-path");
        this.contentType = OBJECT_TYPE;
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.checkPreferences(request);
        super.doView(request, response);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.checkPreferences(request);
        PortletRequestDispatcher prd = this.getPortletContext().getRequestDispatcher(this.editDispatchedPath);
        PortletPreferences preferences = request.getPreferences();
        if (preferences != null) {
            Set preferencesEntries = preferences.getMap().entrySet();
            for (Map.Entry entry : preferencesEntries) {
                request.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        prd.include(request, response);
    }

    private void checkPreferences(RenderRequest request) throws PortletException {
        PortletPreferences preferences = request.getPreferences();
        if (preferences.getValue(PORTLET_INSTANCE_ID_PARAM, null) != null && preferences.getValue(WIDGET_ID_PARAM, null) == null) {
            long portletInstanceId = Long.parseLong(preferences.getValue(PORTLET_INSTANCE_ID_PARAM, null));
            Identity identity = Utils.getViewerIdentity();
            try {
                WidgetService widgetService = (WidgetService)ExoContainerContext.getService(WidgetService.class);
                Widget widget = widgetService.getWidgetByPortletId(portletInstanceId);
                if (widget == null) {
                    widget = new Widget();
                    widget.setPortletId(Long.valueOf(portletInstanceId));
                    widget = widgetService.createWidget(widget, identity.getRemoteId());
                }
                preferences.setValue(WIDGET_ID_PARAM, String.valueOf(widget.getId()));
                this.savePreference(WIDGET_ID_PARAM, String.valueOf(widget.getId()));
            }
            catch (IllegalAccessException e) {
                throw new PortletException("User not allowed to change Widget settings", (Throwable)e);
            }
            catch (ObjectAlreadyExistsException e) {
                throw new PortletException("Associated Widget already exists for portlet with instance id " + portletInstanceId, (Throwable)e);
            }
        }
    }
}

