/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.debug;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ObjectDebuger {
    private static final Log LOG = ExoLogger.getLogger("exo.kernel.commons.ObjectDebuger");

    public static void printObject(Object o) throws Exception {
    }

    public static String asString(Object o) {
        StringBuffer b = new StringBuffer();
        try {
            HashMap map = new HashMap(100);
            if (o instanceof Collection) {
                ObjectDebuger.printCollection(map, (Collection)o, b, "");
            } else if (o instanceof Map) {
                ObjectDebuger.printCollection(map, ((Map)o).values(), b, "");
            } else {
                ObjectDebuger.printObject(map, o, b, "");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getLocalizedMessage(), ex);
            b.append("\n").append(ex.getMessage());
        }
        return b.toString();
    }

    private static void printObject(Map printedObjects, Object o, StringBuffer b, String indent) throws Exception {
        if (o == null) {
            return;
        }
        if (printedObjects.containsKey(o)) {
            return;
        }
        printedObjects.put(o, o);
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        b.append((String)indent).append("object[" + ObjectDebuger.getClassName(clazz)).append("]: ").append(o).append("\n");
        indent = (String)indent + "  ";
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            if (fields[i].getDeclaringClass().getName().startsWith("java")) continue;
            Class<?> type = fields[i].getType();
            fields[i].setAccessible(true);
            if (type.equals(String.class)) {
                Object s = (String)fields[i].get(o);
                if (s == null) {
                    s = "";
                }
                if (((String)s).length() > 50) {
                    s = ((String)s).substring(0, 50) + "...\n";
                }
                b.append((String)indent).append(fields[i].getName()).append(": ").append((String)s).append("\n");
                continue;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE)) {
                value = fields[i].get(o);
                b.append((String)indent).append(fields[i].getName()).append(": ").append(value).append("\n");
                continue;
            }
            value = fields[i].get(o);
            if (value instanceof Collection) {
                b.append((String)indent).append(fields[i].getName()).append("[Collection]\n");
                ObjectDebuger.printCollection(printedObjects, (Collection)value, b, (String)indent + "  ");
                continue;
            }
            if (value instanceof Map) {
                b.append((String)indent).append(fields[i].getName()).append("[Map]\n");
                ObjectDebuger.printMap((Map)value, b, (String)indent + "  ");
                continue;
            }
            ObjectDebuger.printObject(printedObjects, value, b, (String)indent);
        }
    }

    private static void printMap(Map map, StringBuffer b, String indent) throws Exception {
        for (Map.Entry entry : map.entrySet()) {
            b.append(indent).append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
        }
    }

    private static void printCollection(Map printedObjects, Collection c, StringBuffer b, String indent) throws Exception {
        for (Object o : c) {
            ObjectDebuger.printObject(printedObjects, o, b, indent);
        }
    }

    private static String getClassName(Class clazz) {
        String name = clazz.getName();
        int idx = name.lastIndexOf(".");
        if (idx > 0) {
            name = name.substring(idx + 1, name.length());
        }
        return name;
    }
}

