/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Properties;
import java.util.function.BiConsumer;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.PropertyManager;

public class TestPropertyManager
extends TestCase {
    public void testDevelopping() {
        this._testDeveloppingIsNull();
        this._testDeveloppingIsTrue();
        this._testDeveloppingIsFalse();
        this._testDeveloppingIsMaybe();
    }

    public void testGetPropertiesByPattern() {
        System.setProperty("exodev.prop1.enabled", "value1");
        System.setProperty("exodev.prop2.disabled", "value2");
        System.setProperty("my.prop3.enabled", "value3");
        System.setProperty("my.exodev.enabled", "value1");
        PropertyManager.refresh();
        TestPropertyManager.assertTrue((boolean)PropertyManager.getUseCache());
        TestPropertyManager.assertFalse((boolean)PropertyManager.isDevelopping());
        Properties result = PropertyManager.getPropertiesByPattern((String)"^exodev\\..*$");
        TestPropertyManager.assertNotNull((Object)result);
        TestPropertyManager.assertEquals((int)result.size(), (int)2);
        result.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> TestPropertyManager.assertTrue((boolean)k.toString().startsWith("exodev"))));
        result = PropertyManager.getPropertiesByPattern((String)"exodev\\..*\\.enabled");
        TestPropertyManager.assertNotNull((Object)result);
        TestPropertyManager.assertEquals((int)result.size(), (int)1);
        TestPropertyManager.assertTrue((boolean)"exodev.prop1.enabled".equals(result.propertyNames().nextElement()));
    }

    private void _testDeveloppingIsNull() {
        TestPropertyManager.assertNull((Object)System.getProperty("exo.product.developing"));
        PropertyManager.refresh();
        TestPropertyManager.assertTrue((boolean)PropertyManager.getUseCache());
        TestPropertyManager.assertFalse((boolean)PropertyManager.isDevelopping());
        TestPropertyManager.assertNull((Object)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "bar");
        TestPropertyManager.assertEquals((String)"bar", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "juu");
        PropertyManager.refresh();
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "daa");
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        PropertyManager.setProperty((String)"foo", (String)"daa");
        TestPropertyManager.assertEquals((String)"daa", (String)PropertyManager.getProperty((String)"foo"));
        TestPropertyManager.assertEquals((String)"daa", (String)System.getProperty("foo"));
    }

    private void _testDeveloppingIsTrue() {
        System.setProperty("exo.product.developing", "true");
        PropertyManager.refresh();
        TestPropertyManager.assertFalse((boolean)PropertyManager.getUseCache());
        TestPropertyManager.assertTrue((boolean)PropertyManager.isDevelopping());
        System.setProperty("foo", "bar");
        TestPropertyManager.assertEquals((String)"bar", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "juu");
        PropertyManager.refresh();
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "daa");
        TestPropertyManager.assertEquals((String)"daa", (String)PropertyManager.getProperty((String)"foo"));
        PropertyManager.setProperty((String)"foo", (String)"daa");
        TestPropertyManager.assertEquals((String)"daa", (String)PropertyManager.getProperty((String)"foo"));
        TestPropertyManager.assertEquals((String)"daa", (String)System.getProperty("foo"));
    }

    private void _testDeveloppingIsFalse() {
        System.setProperty("exo.product.developing", "false");
        PropertyManager.refresh();
        TestPropertyManager.assertTrue((boolean)PropertyManager.getUseCache());
        TestPropertyManager.assertFalse((boolean)PropertyManager.isDevelopping());
        System.setProperty("foo", "bar");
        TestPropertyManager.assertEquals((String)"bar", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "juu");
        PropertyManager.refresh();
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "daa");
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        PropertyManager.setProperty((String)"foo", (String)"daa");
        TestPropertyManager.assertEquals((String)"daa", (String)PropertyManager.getProperty((String)"foo"));
        TestPropertyManager.assertEquals((String)"daa", (String)System.getProperty("foo"));
    }

    private void _testDeveloppingIsMaybe() {
        System.setProperty("exo.product.developing", "maybe");
        PropertyManager.refresh();
        TestPropertyManager.assertTrue((boolean)PropertyManager.getUseCache());
        TestPropertyManager.assertFalse((boolean)PropertyManager.isDevelopping());
        System.setProperty("foo", "bar");
        TestPropertyManager.assertEquals((String)"bar", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "juu");
        PropertyManager.refresh();
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        System.setProperty("foo", "daa");
        TestPropertyManager.assertEquals((String)"juu", (String)PropertyManager.getProperty((String)"foo"));
        PropertyManager.setProperty((String)"foo", (String)"daa");
        TestPropertyManager.assertEquals((String)"daa", (String)PropertyManager.getProperty((String)"foo"));
        TestPropertyManager.assertEquals((String)"daa", (String)System.getProperty("foo"));
    }
}

