/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.exoplatform.services.cache.concurrent.Item;
import org.exoplatform.services.cache.concurrent.SynchronizedQueue;
import org.junit.Assert;
import org.junit.Test;

public class TestSynchronizedQueue {
    @Test
    public void testTrim() throws Exception {
        final SynchronizedQueue queue = new SynchronizedQueue(null);
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch finish = new CountDownLatch(1000);
        for (int i = 0; i < 1000; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"CountDownLatch fail to wait");
                    }
                    for (int j = 0; j < 10000; ++j) {
                        if (queue.size() > 1000) continue;
                        queue.add(new Item());
                        queue.trim(1000);
                    }
                    finish.countDown();
                }
            });
            t.start();
        }
        start.countDown();
        finish.await(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1000L, (long)queue.size());
    }
}

