/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LoggingCacheListener
implements CacheListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.LoggingCacheListener");

    @Override
    public void onClearCache(CacheListenerContext context) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleared region " + context.getCacheInfo().getName()));
        }
    }

    public void onExpire(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Expired entry " + String.valueOf(key) + " on region " + context.getCacheInfo().getName()));
        }
    }

    public void onGet(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Get entry " + String.valueOf(key) + " on region " + context.getCacheInfo().getName()));
        }
    }

    public void onPut(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Put entry " + String.valueOf(key) + " region " + context.getCacheInfo().getName()));
        }
        if (LOG.isWarnEnabled()) {
            double treshold;
            int maxSize = context.getCacheInfo().getMaxSize();
            int size = context.getCacheInfo().getSize();
            if ((double)size >= (treshold = (double)maxSize * 0.95)) {
                LOG.warn((Object)("region " + context.getCacheInfo().getName() + " is 95% full, consider extending maxSize"));
            }
        }
    }

    public void onRemove(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removed entry " + String.valueOf(key) + " region " + context.getCacheInfo().getName()));
        }
    }
}

