/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.command.impl.CommandService;

public class MultiConfigServiceTest
extends TestCase {
    private StandaloneContainer container;
    private static final String IS = "<catalog name='fromput'><command name='put' className='org.exoplatform.services.command.TestCommand1'/></catalog>";
    private final int NUMBER_OF_COMMANDS_IN_DEF = 4;
    private final int NUMBER_OF_COMMANDS_IN_CATALOG1 = 2;

    public void setUp() throws Exception {
        StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-multi-configuration.xml");
        this.container = StandaloneContainer.getInstance();
    }

    public void testMultiConfig() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        MultiConfigServiceTest.assertNotNull((Object)cservice);
        MultiConfigServiceTest.assertTrue((boolean)cservice.getCatalogNames().hasNext());
        Iterator commands = cservice.getCatalog().getNames();
        int cnt = 0;
        while (commands.hasNext()) {
            commands.next();
            ++cnt;
        }
        MultiConfigServiceTest.assertEquals((int)4, (int)cnt);
        commands = cservice.getCatalog("catalog1").getNames();
        cnt = 0;
        while (commands.hasNext()) {
            commands.next();
            ++cnt;
        }
        MultiConfigServiceTest.assertEquals((int)2, (int)cnt);
    }

    public void testIfPutCatalogDoesNotRemoveCommands() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        MultiConfigServiceTest.assertNotNull((Object)cservice);
        MultiConfigServiceTest.assertTrue((boolean)cservice.getCatalogNames().hasNext());
        Iterator commands = cservice.getCatalog().getNames();
        int cnt = 0;
        while (commands.hasNext()) {
            commands.next();
            ++cnt;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(IS.getBytes());
        cservice.putCatalog((InputStream)is);
        MultiConfigServiceTest.assertTrue((boolean)cservice.getCatalogNames().hasNext());
        commands = cservice.getCatalog().getNames();
        cnt = 0;
        while (commands.hasNext()) {
            commands.next();
            ++cnt;
        }
        commands = cservice.getCatalog("fromput").getNames();
        cnt = 0;
        while (commands.hasNext()) {
            commands.next();
            ++cnt;
        }
    }

    public void tearDown() {
        CatalogFactoryBase.clear();
        this.container.stop();
    }
}

