/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan.distributed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheFactoryImpl;
import org.exoplatform.services.cache.impl.infinispan.distributed.DistributedExoCache;
import org.exoplatform.services.ispn.DistributedCacheManager;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;

public class TestDistributedExoCache
extends TestCase {
    CacheService service;
    DistributedExoCache<Serializable, Object> cache;
    DistributedExoCache<Serializable, Object> cache2;

    public TestDistributedExoCache(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.service = (CacheService)PortalContainer.getInstance().getComponentInstanceOfType(CacheService.class);
        this.cache = (DistributedExoCache)this.service.getCacheInstance("cache-distributed");
        this.cache2 = (DistributedExoCache)this.service.getCacheInstance("cache-distributed2");
        this.cache2.put((Serializable)new MyKey("a"), (Object)"a");
    }

    protected void tearDown() throws Exception {
        this.cache.clearCache();
        this.cache2.clearCache();
    }

    public void testPut() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        TestDistributedExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        this.cache.put((Serializable)new MyKey("a"), (Object)"c");
        TestDistributedExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        this.cache.put((Serializable)new MyKey("d"), (Object)"c");
        TestDistributedExoCache.assertEquals((int)4, (int)this.cache.getCacheSize());
    }

    public void testClearCache() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        TestDistributedExoCache.assertTrue((this.cache.getCacheSize() > 0 ? 1 : 0) != 0);
        this.cache.clearCache();
        TestDistributedExoCache.assertTrue((this.cache.getCacheSize() == 0 ? 1 : 0) != 0);
    }

    public void testGet() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        TestDistributedExoCache.assertEquals((Object)"a", (Object)this.cache.get((Serializable)new MyKey("a")));
        this.cache.put((Serializable)new MyKey("a"), (Object)"c");
        TestDistributedExoCache.assertEquals((Object)"c", (Object)this.cache.get((Serializable)new MyKey("a")));
        this.cache.remove((Serializable)new MyKey("a"));
        TestDistributedExoCache.assertEquals(null, (Object)this.cache.get((Serializable)new MyKey("a")));
        TestDistributedExoCache.assertEquals(null, (Object)this.cache.get((Serializable)new MyKey("x")));
    }

    public void testRemove() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)1);
        this.cache.put((Serializable)new MyKey("b"), (Object)2);
        this.cache.put((Serializable)new MyKey("c"), (Object)3);
        TestDistributedExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)1, (Object)this.cache.remove((Serializable)new MyKey("a")));
        TestDistributedExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)2, (Object)this.cache.remove((Serializable)new MyKey("b")));
        TestDistributedExoCache.assertEquals((int)1, (int)this.cache.getCacheSize());
        TestDistributedExoCache.assertEquals(null, (Object)this.cache.remove((Serializable)new MyKey("x")));
        TestDistributedExoCache.assertEquals((int)1, (int)this.cache.getCacheSize());
    }

    public void testPutMap() throws Exception {
        HashMap<Serializable, Object> values = new HashMap();
        values.put(new MyKey("a"), "a");
        values.put(new MyKey("b"), "b");
        TestDistributedExoCache.assertEquals((int)0, (int)this.cache.getCacheSize());
        this.cache.putMap(values);
        TestDistributedExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
        values = new HashMap<Serializable, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<Map.Entry<Serializable, Object>> entrySet() {
                LinkedHashSet<Map.Entry<Serializable, Object>> set = new LinkedHashSet<Map.Entry<Serializable, Object>>(super.entrySet());
                set.add(new Map.Entry<Serializable, Object>(this){

                    @Override
                    public Object setValue(Object paramV) {
                        return null;
                    }

                    @Override
                    public Object getValue() {
                        throw new RuntimeException("An exception");
                    }

                    @Override
                    public Serializable getKey() {
                        return "c";
                    }
                });
                return set;
            }
        };
        values.put(new MyKey("e"), "e");
        values.put(new MyKey("d"), "d");
        this.cache.putMap((Map)values);
        TestDistributedExoCache.assertEquals((int)2, (int)this.cache.getCacheSize());
    }

    public void testGetCachedObjects() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        this.cache.put((Serializable)new MyKey("d"), null);
        TestDistributedExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        List values = this.cache.getCachedObjects();
        TestDistributedExoCache.assertEquals((int)3, (int)values.size());
        TestDistributedExoCache.assertTrue((boolean)values.contains("a"));
        TestDistributedExoCache.assertTrue((boolean)values.contains("b"));
        TestDistributedExoCache.assertTrue((boolean)values.contains("c"));
    }

    public void testRemoveCachedObjects() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.put((Serializable)new MyKey("b"), (Object)"b");
        this.cache.put((Serializable)new MyKey("c"), (Object)"c");
        this.cache.put((Serializable)new MyKey("d"), null);
        TestDistributedExoCache.assertEquals((int)3, (int)this.cache.getCacheSize());
        List values = this.cache.removeCachedObjects();
        TestDistributedExoCache.assertEquals((int)3, (int)values.size());
        TestDistributedExoCache.assertTrue((boolean)values.contains("a"));
        TestDistributedExoCache.assertTrue((boolean)values.contains("b"));
        TestDistributedExoCache.assertTrue((boolean)values.contains("c"));
        TestDistributedExoCache.assertEquals((int)0, (int)this.cache.getCacheSize());
    }

    public void testSelect() throws Exception {
        this.cache.put((Serializable)new MyKey("a"), (Object)1);
        this.cache.put((Serializable)new MyKey("b"), (Object)2);
        this.cache.put((Serializable)new MyKey("c"), (Object)3);
        final AtomicInteger count = new AtomicInteger();
        CachedObjectSelector<Serializable, Object> selector = new CachedObjectSelector<Serializable, Object>(){

            public void onSelect(ExoCache<? extends Serializable, ? extends Object> cache, Serializable key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                TestCase.assertTrue((key.equals(new MyKey("a")) || key.equals(new MyKey("b")) || key.equals(new MyKey("c")) ? 1 : 0) != 0);
                TestCase.assertTrue((ocinfo.get().equals(1) || ocinfo.get().equals(2) || ocinfo.get().equals(3) ? 1 : 0) != 0);
                count.incrementAndGet();
            }

            public boolean select(Serializable key, ObjectCacheInfo<? extends Object> ocinfo) {
                return true;
            }
        };
        this.cache.select((CachedObjectSelector)selector);
        TestDistributedExoCache.assertEquals((int)3, (int)count.intValue());
    }

    public void testGetHitsNMisses() throws Exception {
        int hits = this.cache.getCacheHit();
        int misses = this.cache.getCacheMiss();
        this.cache.put((Serializable)new MyKey("a"), (Object)"a");
        this.cache.get((Serializable)new MyKey("a"));
        this.cache.remove((Serializable)new MyKey("a"));
        this.cache.get((Serializable)new MyKey("a"));
        this.cache.get((Serializable)new MyKey("z"));
        TestDistributedExoCache.assertEquals((int)1, (int)(this.cache.getCacheHit() - hits));
        TestDistributedExoCache.assertEquals((int)2, (int)(this.cache.getCacheMiss() - misses));
    }

    public void testMultiThreading() throws Exception {
        Thread thread;
        int i;
        int i2;
        int totalElement = 100;
        int totalTimes = 20;
        int reader = 20;
        int writer = 10;
        int remover = 5;
        int cleaner = 1;
        final CountDownLatch startSignalWriter = new CountDownLatch(1);
        final CountDownLatch startSignalOthers = new CountDownLatch(1);
        final CountDownLatch doneSignal = new CountDownLatch(reader + writer + remover);
        final List<Exception> errors = Collections.synchronizedList(new ArrayList());
        int i22 = 0;
        while (i22 < writer) {
            final int index = i22++;
            Thread thread2 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalWriter.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                TestDistributedExoCache.this.cache.put((Serializable)new MyKey("key" + i), (Object)("value" + i));
                            }
                            if (index == 0 && j == 0) {
                                startSignalOthers.countDown();
                            }
                            3.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread2.start();
        }
        startSignalWriter.countDown();
        for (i2 = 0; i2 < reader; ++i2) {
            Thread thread3 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                TestDistributedExoCache.this.cache.get((Serializable)new MyKey("key" + i));
                            }
                            4.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread3.start();
        }
        for (i2 = 0; i2 < remover; ++i2) {
            Thread thread4 = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignalOthers.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                TestDistributedExoCache.this.cache.remove((Serializable)new MyKey("key" + i));
                            }
                            5.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }
            };
            thread4.start();
        }
        doneSignal.await();
        for (i2 = 0; i2 < 100; ++i2) {
            this.cache.put((Serializable)new MyKey("key" + i2), (Object)("value" + i2));
        }
        TestDistributedExoCache.assertEquals((int)100, (int)this.cache.getCacheSize());
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch doneSignal2 = new CountDownLatch(writer + cleaner);
        for (i = 0; i < writer; ++i) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignal.await();
                        for (int j = 0; j < 20; ++j) {
                            for (int i = 0; i < 100; ++i) {
                                TestDistributedExoCache.this.cache.put((Serializable)new MyKey("key" + i), (Object)("value" + i));
                            }
                            6.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal2.countDown();
                    }
                }
            };
            thread.start();
        }
        for (i = 0; i < cleaner; ++i) {
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        startSignal.await();
                        for (int j = 0; j < 20; ++j) {
                            7.sleep(150L);
                            TestDistributedExoCache.this.cache.clearCache();
                        }
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                    finally {
                        doneSignal2.countDown();
                    }
                }
            };
            thread.start();
        }
        this.cache.clearCache();
        TestDistributedExoCache.assertEquals((int)0, (int)this.cache.getCacheSize());
        if (!errors.isEmpty()) {
            for (Exception e : errors) {
                e.printStackTrace();
            }
            throw errors.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCache() throws Exception {
        PortalContainer pc = PortalContainer.getInstance();
        ExoCacheConfig config = new ExoCacheConfig();
        config.setName("MyCacheDistributed");
        config.setMaxSize(5);
        config.setLiveTime(1L);
        config.setImplementation("LRU");
        config.setDistributed(true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("infinispan-num-owners", "1");
        ConfigurationManager cm = (ConfigurationManager)pc.getComponentInstanceOfType(ConfigurationManager.class);
        DistributedCacheManager dcm2 = new DistributedCacheManager("jar:/conf/portal/distributed-cache-configuration.xml", params, cm);
        DistributedExoCache cache1 = (DistributedExoCache)((ExoCacheFactory)pc.getComponentInstanceOfType(ExoCacheFactory.class)).createCache(config);
        DistributionManager dm = cache1.getCache().getDistributionManager();
        DistributedExoCache cache2 = (DistributedExoCache)new ExoCacheFactoryImpl((ExoContainerContext)pc.getComponentInstanceOfType(ExoContainerContext.class), "jar:/conf/portal/cache-configuration-template.xml", null, cm, dcm2).createCache(config);
        KeyAffinityService kas1 = KeyAffinityServiceFactory.newLocalKeyAffinityService((Cache)cache1.getCache(), (KeyGenerator)new MyKeyGenerator(cache1.getFullName()), (Executor)Executors.newSingleThreadExecutor(), (int)100);
        KeyAffinityService kas2 = KeyAffinityServiceFactory.newLocalKeyAffinityService((Cache)cache2.getCache(), (KeyGenerator)new MyKeyGenerator(cache1.getFullName()), (Executor)Executors.newSingleThreadExecutor(), (int)100);
        try {
            for (int i = 0; i < 2; ++i) {
                MyKey a = i == 0 ? new MyKey("a", ((MyKey)((DistributedExoCache.CacheKey)kas1.getKeyForAddress((Address)cache1.getCache().getRpcManager().getAddress())).getKey()).value) : new MyKey("a", ((MyKey)((DistributedExoCache.CacheKey)kas2.getKeyForAddress((Address)cache2.getCache().getRpcManager().getAddress())).getKey()).value);
                for (int j = 0; j < 2; ++j) {
                    MyKey b = j == 0 ? new MyKey("b", ((MyKey)((DistributedExoCache.CacheKey)kas1.getKeyForAddress((Address)cache1.getCache().getRpcManager().getAddress())).getKey()).value) : new MyKey("b", ((MyKey)((DistributedExoCache.CacheKey)kas2.getKeyForAddress((Address)cache2.getCache().getRpcManager().getAddress())).getKey()).value);
                    for (int k = 0; k < 2; ++k) {
                        MyKey c = k == 0 ? new MyKey("c", ((MyKey)((DistributedExoCache.CacheKey)kas1.getKeyForAddress((Address)cache1.getCache().getRpcManager().getAddress())).getKey()).value) : new MyKey("c", ((MyKey)((DistributedExoCache.CacheKey)kas2.getKeyForAddress((Address)cache2.getCache().getRpcManager().getAddress())).getKey()).value);
                        this.checkUseCase((DistributedExoCache<Serializable, Object>)cache1, (DistributedExoCache<Serializable, Object>)cache2, dm, a, b, c);
                    }
                }
            }
        }
        finally {
            dcm2.stop();
        }
    }

    private void checkUseCase(DistributedExoCache<Serializable, Object> cache1, DistributedExoCache<Serializable, Object> cache2, DistributionManager dm, Object a, Object b, Object c) throws InterruptedException {
        MyCacheListener listener1 = new MyCacheListener();
        cache1.addCacheListener((CacheListener)listener1);
        MyCacheListener listener2 = new MyCacheListener();
        cache2.addCacheListener((CacheListener)listener2);
        boolean isALocal = dm.getLocality((Object)new DistributedExoCache.CacheKey(cache1.getFullName(), (Object)new MyKey(a))).isLocal();
        boolean isBLocal = dm.getLocality((Object)new DistributedExoCache.CacheKey(cache1.getFullName(), (Object)new MyKey(b))).isLocal();
        boolean isCLocal = dm.getLocality((Object)new DistributedExoCache.CacheKey(cache1.getFullName(), (Object)new MyKey(c))).isLocal();
        MyKey key = new MyKey(a);
        cache1.put((Serializable)key, (Object)"b");
        TestDistributedExoCache.assertEquals((int)1, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)"b", (Object)cache2.get((Serializable)new MyKey(a)));
        TestDistributedExoCache.assertEquals((int)1, (int)cache2.getCacheSize());
        int put1 = 1;
        int put2 = isALocal ? 0 : 1;
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)0, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.get);
        MyKey key2 = new MyKey(b);
        cache2.put((Serializable)key2, (Object)"c");
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)"c", (Object)cache1.get((Serializable)new MyKey(b)));
        TestDistributedExoCache.assertEquals((int)(put1 += isBLocal ? 1 : 0), (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)(++put2), (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.get);
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.get);
        key = new MyKey(a);
        cache2.put((Serializable)key, (Object)"a");
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)"a", (Object)cache1.get((Serializable)new MyKey(a)));
        TestDistributedExoCache.assertEquals((int)(put1 += isALocal ? 1 : 0), (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)(++put2), (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)2, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.get);
        key = new MyKey(a);
        cache2.remove((Serializable)key);
        TestDistributedExoCache.assertEquals((int)1, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)1, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)2, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.get);
        int remove1 = isALocal ? 1 : 0;
        int remove2 = 1;
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)remove2, (int)listener2.remove);
        key = new MyKey(c);
        cache1.put((Serializable)key, (Object)"c");
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((Object)"c", (Object)cache2.get((Serializable)new MyKey(c)));
        int n = isCLocal ? 0 : 1;
        TestDistributedExoCache.assertEquals((int)(++put1), (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)(put2 += n), (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)2, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)2, (int)listener2.get);
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)remove2, (int)listener2.remove);
        TestDistributedExoCache.assertEquals((int)0, (int)listener1.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.clearCache);
        cache1.clearCache();
        TestDistributedExoCache.assertEquals((int)0, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertNull((Object)cache1.get((Serializable)new MyKey(b)));
        TestDistributedExoCache.assertNull((Object)cache1.get((Serializable)new MyKey(c)));
        TestDistributedExoCache.assertNull((Object)cache2.get((Serializable)new MyKey(b)));
        TestDistributedExoCache.assertNull((Object)cache2.get((Serializable)new MyKey(c)));
        TestDistributedExoCache.assertEquals((int)0, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)4, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)4, (int)listener2.get);
        int n2 = isBLocal ? 0 : 1;
        int n3 = isCLocal ? 0 : 1;
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)(remove2 += n2 + n3), (int)listener2.remove);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.clearCache);
        HashMap<Serializable, Object> values = new HashMap();
        key = new MyKey(a);
        key2 = new MyKey(b);
        values.put(key, "a");
        values.put(key2, "b");
        cache1.putMap(values);
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        Thread.sleep(40L);
        TestDistributedExoCache.assertEquals((Object)"a", (Object)cache1.get((Serializable)new MyKey(a)));
        TestDistributedExoCache.assertEquals((Object)"b", (Object)cache1.get((Serializable)new MyKey(b)));
        TestDistributedExoCache.assertEquals((Object)"a", (Object)cache2.get((Serializable)new MyKey(a)));
        TestDistributedExoCache.assertEquals((Object)"b", (Object)cache2.get((Serializable)new MyKey(b)));
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        int n4 = isALocal ? 0 : 1;
        int n5 = isBLocal ? 0 : 1;
        TestDistributedExoCache.assertEquals((int)(put1 += 2), (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)(put2 += n4 + n5), (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)6, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)6, (int)listener2.get);
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)remove2, (int)listener2.remove);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.clearCache);
        values = new HashMap<Serializable, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<Map.Entry<Serializable, Object>> entrySet() {
                LinkedHashSet<Map.Entry<Serializable, Object>> set = new LinkedHashSet<Map.Entry<Serializable, Object>>(super.entrySet());
                set.add(new Map.Entry<Serializable, Object>(this){

                    @Override
                    public Object setValue(Object paramV) {
                        return null;
                    }

                    @Override
                    public Object getValue() {
                        throw new RuntimeException("An exception");
                    }

                    @Override
                    public Serializable getKey() {
                        return "c";
                    }
                });
                return set;
            }
        };
        values.put(new MyKey("e"), "e");
        values.put(new MyKey("d"), "d");
        cache1.putMap((Map)values);
        TestDistributedExoCache.assertEquals((int)2, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)2, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)6, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)6, (int)listener2.get);
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)remove2, (int)listener2.remove);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener1.expire);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.expire);
        cache2.clearCache();
        TestDistributedExoCache.assertEquals((int)0, (int)cache1.getCacheSize());
        TestDistributedExoCache.assertEquals((int)0, (int)cache2.getCacheSize());
        TestDistributedExoCache.assertEquals((int)put1, (int)listener1.put);
        TestDistributedExoCache.assertEquals((int)put2, (int)listener2.put);
        TestDistributedExoCache.assertEquals((int)6, (int)listener1.get);
        TestDistributedExoCache.assertEquals((int)6, (int)listener2.get);
        int n6 = isALocal ? 0 : 1;
        int n7 = isBLocal ? 0 : 1;
        TestDistributedExoCache.assertEquals((int)remove1, (int)listener1.remove);
        TestDistributedExoCache.assertEquals((int)(remove2 += n6 + n7), (int)listener2.remove);
        TestDistributedExoCache.assertEquals((int)1, (int)listener1.clearCache);
        TestDistributedExoCache.assertEquals((int)1, (int)listener2.clearCache);
        TestDistributedExoCache.assertEquals((int)0, (int)listener1.expire);
        TestDistributedExoCache.assertEquals((int)0, (int)listener2.expire);
    }

    public static class MyKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object value;
        public String displayValue;

        public MyKey() {
        }

        public MyKey(Object value) {
            this.value = value;
        }

        public MyKey(String displayValue, Object value) {
            this.displayValue = displayValue;
            this.value = value;
        }

        public boolean equals(Object paramObject) {
            return paramObject instanceof MyKey && ((MyKey)paramObject).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.displayValue == null ? this.value.toString() : this.displayValue;
        }
    }

    public static class MyKeyGenerator
    implements KeyGenerator<DistributedExoCache.CacheKey<Serializable>> {
        public static final Random rnd = new Random();
        private String fullName;

        public MyKeyGenerator(String fullName) {
            this.fullName = fullName;
        }

        public DistributedExoCache.CacheKey<Serializable> getKey() {
            return new DistributedExoCache.CacheKey(this.fullName, (Object)new MyKey(rnd.nextLong()));
        }
    }

    public static class MyCacheListener
    implements CacheListener<Serializable, Object> {
        public int clearCache;
        public int expire;
        public int get;
        public int put;
        public int remove;

        public void onClearCache(CacheListenerContext context) throws Exception {
            ++this.clearCache;
        }

        public void onExpire(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.expire;
        }

        public void onGet(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.get;
        }

        public void onPut(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.put;
        }

        public void onRemove(CacheListenerContext context, Serializable key, Object obj) throws Exception {
            ++this.remove;
        }
    }
}

