/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import junit.framework.TestCase;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.impl.infinispan.AbstractExoCache;
import org.exoplatform.services.cache.impl.infinispan.TestExoCacheCreator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;

public class TestExoCacheFactoryImpl
extends TestCase {
    CacheService service_;

    public TestExoCacheFactoryImpl(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.service_ = (CacheService)PortalContainer.getInstance().getComponentInstanceOfType(CacheService.class);
    }

    public void testCacheFactory() {
        ExoCache cache = this.service_.getCacheInstance("myCache");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache instanceof AbstractExoCache));
        AbstractExoCache aCache = (AbstractExoCache)cache;
        TestExoCacheFactoryImpl.assertTrue((String)"expect a local cache", (aCache.cache.getCacheConfiguration().clustering().cacheMode() == CacheMode.LOCAL ? 1 : 0) != 0);
        aCache.cache.stop();
        cache = this.service_.getCacheInstance("cacheDistributed");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache instanceof AbstractExoCache));
        aCache = (AbstractExoCache)cache;
        TestExoCacheFactoryImpl.assertTrue((String)"expect a distributed cache", (aCache.cache.getCacheConfiguration().clustering().cacheMode() == CacheMode.REPL_SYNC ? 1 : 0) != 0);
        aCache.cache.stop();
        cache = this.service_.getCacheInstance("myCustomCache");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache instanceof AbstractExoCache));
        aCache = (AbstractExoCache)cache;
        TestExoCacheFactoryImpl.assertTrue((String)"expect a distributed cache", (aCache.cache.getCacheConfiguration().clustering().cacheMode() == CacheMode.REPL_SYNC ? 1 : 0) != 0);
        aCache.cache.stop();
    }

    public void testExoCacheCreator() {
        ExoCache cache = this.service_.getCacheInstance("test-default-impl");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache instanceof AbstractExoCache));
        AbstractExoCache aCache = (AbstractExoCache)cache;
        aCache.cache.stop();
        cache = this.service_.getCacheInstance("test-custom-impl-with-old-config");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of TestExoCache", (boolean)(cache instanceof TestExoCacheCreator.TestExoCache));
        cache = this.service_.getCacheInstance("test-custom-impl-with-new-config");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of TestExoCache", (boolean)(cache instanceof TestExoCacheCreator.TestExoCache));
    }

    public void testSameCacheManager() {
        ExoCache cache1 = this.service_.getCacheInstance("myCustomCache");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache1 instanceof AbstractExoCache));
        AbstractExoCache aCache1 = (AbstractExoCache)cache1;
        EmbeddedCacheManager cacheContainer1 = aCache1.cache.getCacheManager();
        ExoCache cache2 = this.service_.getCacheInstance("myCustomCache-Bis");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache2 instanceof AbstractExoCache));
        AbstractExoCache aCache2 = (AbstractExoCache)cache2;
        EmbeddedCacheManager cacheContainer2 = aCache2.cache.getCacheManager();
        TestExoCacheFactoryImpl.assertTrue((String)"The CacheContainer should be the same", (cacheContainer1 == cacheContainer2 ? 1 : 0) != 0);
        ExoCache cache3 = this.service_.getCacheInstance("myCustomCache-Bis2");
        TestExoCacheFactoryImpl.assertTrue((String)"expect an instance of AbstractExoCache", (boolean)(cache3 instanceof AbstractExoCache));
        AbstractExoCache aCache3 = (AbstractExoCache)cache3;
        EmbeddedCacheManager cacheContainer3 = aCache3.cache.getCacheManager();
        TestExoCacheFactoryImpl.assertTrue((String)"The CacheContainer should be the same", (cacheContainer1 == cacheContainer3 ? 1 : 0) != 0);
        aCache1.cache.stop();
        aCache2.cache.stop();
    }
}

