/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.definition;

import java.util.List;
import java.util.Map;
import org.exoplatform.container.definition.PortalContainerDefinition;

public interface PortalContainerDefinitionChange {
    public void apply(PortalContainerDefinition var1);

    public static class AddSettings
    implements PortalContainerDefinitionChange {
        public Map<String, Object> settings;

        @Override
        public void apply(PortalContainerDefinition pcd) {
            if (this.settings == null || this.settings.isEmpty()) {
                return;
            }
            pcd.getSettings().putAll(this.settings);
        }
    }

    public static class AddDependenciesAfter
    implements PortalContainerDefinitionChange {
        public List<String> dependencies;
        public String target;

        @Override
        public void apply(PortalContainerDefinition pcd) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            if (this.target != null && this.target.length() > 0) {
                List<String> lDependencies = pcd.getDependencies();
                int length = lDependencies.size();
                for (int i = 0; i < length; ++i) {
                    String dep = lDependencies.get(i);
                    if (!this.target.equals(dep)) continue;
                    lDependencies.addAll(i + 1, this.dependencies);
                    return;
                }
            }
            pcd.getDependencies().addAll(this.dependencies);
        }
    }

    public static class AddDependenciesBefore
    implements PortalContainerDefinitionChange {
        public List<String> dependencies;
        public String target;

        @Override
        public void apply(PortalContainerDefinition pcd) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            if (this.target != null && this.target.length() > 0) {
                List<String> lDependencies = pcd.getDependencies();
                for (int i = lDependencies.size() - 1; i >= 0; --i) {
                    String dep = lDependencies.get(i);
                    if (!this.target.equals(dep)) continue;
                    lDependencies.addAll(i, this.dependencies);
                    return;
                }
            }
            pcd.getDependencies().addAll(0, this.dependencies);
        }
    }

    public static class AddDependencies
    implements PortalContainerDefinitionChange {
        public List<String> dependencies;

        @Override
        public void apply(PortalContainerDefinition pcd) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            pcd.getDependencies().addAll(this.dependencies);
        }
    }
}

