/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import junit.framework.TestCase;
import org.exoplatform.management.jmx.impl.ExoMBeanInfoBuilder;

public abstract class AbstractExoMBeanTest
extends TestCase {
    protected MBeanServer server;

    protected void setUp() throws Exception {
        this.server = MBeanServerFactory.createMBeanServer();
    }

    protected void tearDown() throws Exception {
        MBeanServerFactory.releaseMBeanServer(this.server);
    }

    protected void assertNotBuildable(Class clazz) {
        try {
            new ExoMBeanInfoBuilder(clazz).build();
            AbstractExoMBeanTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Bean register(String name, Class clazz) {
        try {
            ObjectName objectName = ObjectName.getInstance(name);
            ModelMBeanInfo info = new ExoMBeanInfoBuilder(clazz).build();
            RequiredModelMBean mbean = new RequiredModelMBean(info);
            mbean.setManagedResource(clazz.newInstance(), "ObjectReference");
            this.server.registerMBean(mbean, objectName);
            return new Bean(objectName, (ModelMBeanInfo)((Object)this.server.getMBeanInfo(objectName)));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class Bean {
        final ObjectName name;
        final ModelMBeanInfo info;

        public Bean(ObjectName name, ModelMBeanInfo info) {
            this.name = name;
            this.info = info;
        }
    }
}

