/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.net.URL;
import org.exoplatform.container.ContainerBuilder;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.jmx.AbstractTestContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class TestPortalContainer
extends AbstractTestContainer {
    public void testGetConfigurationXML() {
        URL rootURL = ((Object)((Object)this)).getClass().getResource("test-exo-container.xml");
        URL portalURL = ((Object)((Object)this)).getClass().getResource("/conf/test-configuration.xml");
        TestPortalContainer.assertNotNull((Object)rootURL);
        TestPortalContainer.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).build();
        String rootConfigXML = RootContainer.getInstance().getConfigurationXML();
        TestPortalContainer.assertNotNull((Object)rootConfigXML);
        int size = rootConfigXML.length();
        int hash = rootConfigXML.hashCode();
        rootConfigXML = RootContainer.getInstance().getConfigurationXML();
        TestPortalContainer.assertNotNull((Object)rootConfigXML);
        TestPortalContainer.assertTrue((size > 0 ? 1 : 0) != 0);
        TestPortalContainer.assertEquals((int)size, (int)rootConfigXML.length());
        TestPortalContainer.assertEquals((int)hash, (int)rootConfigXML.hashCode());
        String portalConfigXML = PortalContainer.getInstance().getConfigurationXML();
        TestPortalContainer.assertTrue((size > 0 ? 1 : 0) != 0);
        TestPortalContainer.assertNotNull((Object)portalConfigXML);
    }

    public void testInitValues() {
        this.createRootContainer("portal-container-config-with-settings.xml");
        TestPortalContainer.assertEquals((String)"myPortal", (String)PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME);
        TestPortalContainer.assertEquals((String)"myRest", (String)PortalContainer.DEFAULT_REST_CONTEXT_NAME);
        TestPortalContainer.assertEquals((String)"my-exo-domain", (String)PortalContainer.DEFAULT_REALM_NAME);
        PortalContainer portal = PortalContainer.getInstance();
        TestPortalContainer.assertEquals((String)"myPortal", (String)portal.getName());
        TestPortalContainer.assertEquals((String)"myRest", (String)portal.getRestContextName());
        TestPortalContainer.assertEquals((String)"my-exo-domain", (String)portal.getRealmName());
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"myPortal"));
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"portal"));
        TestPortalContainer.assertFalse((boolean)PortalContainer.isPortalContainerName((String)"foo"));
        URL rootURL = ((Object)((Object)this)).getClass().getResource("portal-container-config-with-settings.xml");
        URL portalURL = ((Object)((Object)this)).getClass().getResource("portal-container-test-settings-configuration.xml");
        TestPortalContainer.assertNotNull((Object)rootURL);
        TestPortalContainer.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).build();
        portal = PortalContainer.getInstance();
        TestPortalContainer.assertEquals((String)"portal", (String)portal.getName());
        TestPortalContainer.assertEquals((String)"myRest-pcdef", (String)portal.getRestContextName());
        TestPortalContainer.assertEquals((String)"my-exo-domain-pcdef", (String)portal.getRealmName());
        TestPortalContainer.assertNotNull((Object)portal.getContext());
        TestPortalContainer.assertEquals((String)"portal", (String)portal.getContext().getPortalContainerName());
        TestPortalContainer.assertEquals((String)"myRest-pcdef", (String)portal.getContext().getRestContextName());
        TestPortalContainer.assertEquals((String)"my-exo-domain-pcdef", (String)portal.getContext().getRealmName());
        TestPortalContainer.assertEquals((String)"portal", (String)PortalContainer.getCurrentPortalContainerName());
        TestPortalContainer.assertEquals((String)"myRest-pcdef", (String)PortalContainer.getCurrentRestContextName());
        TestPortalContainer.assertEquals((String)"my-exo-domain-pcdef", (String)PortalContainer.getCurrentRealmName());
        TestPortalContainer.assertEquals((String)"myRest-pcdef", (String)PortalContainer.getRestContextName((String)"portal"));
        TestPortalContainer.assertEquals((String)"my-exo-domain-pcdef", (String)PortalContainer.getRealmName((String)"portal"));
        TestPortalContainer.assertEquals((String)"myRest", (String)PortalContainer.getRestContextName((String)"foo"));
        TestPortalContainer.assertEquals((String)"my-exo-domain", (String)PortalContainer.getRealmName((String)"foo"));
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"myPortal"));
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"portal"));
        TestPortalContainer.assertFalse((boolean)PortalContainer.isPortalContainerName((String)"foo"));
        PortalContainer.setInstance(null);
        TestPortalContainer.assertEquals((String)"myPortal", (String)PortalContainer.getCurrentPortalContainerName());
        TestPortalContainer.assertEquals((String)"myRest", (String)PortalContainer.getCurrentRestContextName());
        TestPortalContainer.assertEquals((String)"my-exo-domain", (String)PortalContainer.getCurrentRealmName());
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"myPortal"));
        TestPortalContainer.assertTrue((boolean)PortalContainer.isPortalContainerName((String)"portal"));
        TestPortalContainer.assertFalse((boolean)PortalContainer.isPortalContainerName((String)"foo"));
    }

    public void testSettings() {
        URL rootURL = ((Object)((Object)this)).getClass().getResource("portal-container-config-with-settings.xml");
        URL portalURL = ((Object)((Object)this)).getClass().getResource("portal-container-test-settings-configuration.xml");
        TestPortalContainer.assertNotNull((Object)rootURL);
        TestPortalContainer.assertNotNull((Object)portalURL);
        new ContainerBuilder().withRoot(rootURL).withPortal(portalURL).build();
        PortalContainer portal = PortalContainer.getInstance();
        MyComponent component = (MyComponent)portal.getComponentInstanceOfType(MyComponent.class);
        TestPortalContainer.assertNotNull((Object)component);
        TestPortalContainer.assertEquals((String)"portal", (String)component.getValue("portal"));
        TestPortalContainer.assertEquals((String)"myRest-pcdef", (String)component.getValue("rest"));
        TestPortalContainer.assertEquals((String)"my-exo-domain-pcdef", (String)component.getValue("realm"));
        TestPortalContainer.assertEquals((String)"value", (String)component.getValue("foo"));
        TestPortalContainer.assertEquals((String)"before value after", (String)component.getValue("before foo after"));
        TestPortalContainer.assertEquals((Object)"value", (Object)portal.getSetting("foo"));
        TestPortalContainer.assertNull((Object)portal.getSetting("foo2"));
        TestPortalContainer.assertEquals((Object)"value", (Object)portal.getSetting("string"));
        TestPortalContainer.assertEquals((Object)new Integer(10), (Object)portal.getSetting("int"));
        TestPortalContainer.assertEquals((Object)new Long(10L), (Object)portal.getSetting("long"));
        TestPortalContainer.assertEquals((Object)new Double(10.0), (Object)portal.getSetting("double"));
        TestPortalContainer.assertEquals((Object)new Boolean(true), (Object)portal.getSetting("boolean"));
        TestPortalContainer.assertNotNull((Object)portal.getContext());
        TestPortalContainer.assertEquals((Object)"value", (Object)portal.getContext().getSetting("foo"));
        TestPortalContainer.assertNull((Object)portal.getContext().getSetting("foo2"));
        TestPortalContainer.assertEquals((Object)"value", (Object)portal.getContext().getSetting("string"));
        TestPortalContainer.assertEquals((Object)new Integer(10), (Object)portal.getContext().getSetting("int"));
        TestPortalContainer.assertEquals((Object)new Long(10L), (Object)portal.getContext().getSetting("long"));
        TestPortalContainer.assertEquals((Object)new Double(10.0), (Object)portal.getContext().getSetting("double"));
        TestPortalContainer.assertEquals((Object)new Boolean(true), (Object)portal.getContext().getSetting("boolean"));
        TestPortalContainer.assertEquals((Object)"value", (Object)PortalContainer.getCurrentSetting((String)"foo"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"foo2"));
        TestPortalContainer.assertEquals((Object)"value", (Object)PortalContainer.getCurrentSetting((String)"string"));
        TestPortalContainer.assertEquals((Object)new Integer(10), (Object)PortalContainer.getCurrentSetting((String)"int"));
        TestPortalContainer.assertEquals((Object)new Long(10L), (Object)PortalContainer.getCurrentSetting((String)"long"));
        TestPortalContainer.assertEquals((Object)new Double(10.0), (Object)PortalContainer.getCurrentSetting((String)"double"));
        TestPortalContainer.assertEquals((Object)new Boolean(true), (Object)PortalContainer.getCurrentSetting((String)"boolean"));
        TestPortalContainer.assertEquals((Object)"value", (Object)PortalContainer.getSetting((String)"portal", (String)"foo"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"portal", (String)"foo2"));
        TestPortalContainer.assertEquals((Object)"value", (Object)PortalContainer.getSetting((String)"portal", (String)"string"));
        TestPortalContainer.assertEquals((Object)new Integer(10), (Object)PortalContainer.getSetting((String)"portal", (String)"int"));
        TestPortalContainer.assertEquals((Object)new Long(10L), (Object)PortalContainer.getSetting((String)"portal", (String)"long"));
        TestPortalContainer.assertEquals((Object)new Double(10.0), (Object)PortalContainer.getSetting((String)"portal", (String)"double"));
        TestPortalContainer.assertEquals((Object)new Boolean(true), (Object)PortalContainer.getSetting((String)"portal", (String)"boolean"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"foo"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"foo2"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"string"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"int"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"long"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"double"));
        TestPortalContainer.assertNull((Object)PortalContainer.getSetting((String)"foo", (String)"boolean"));
        PortalContainer.setInstance(null);
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"foo"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"foo2"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"string"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"int"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"long"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"double"));
        TestPortalContainer.assertNull((Object)PortalContainer.getCurrentSetting((String)"boolean"));
    }

    public static class MyComponent {
        private final InitParams params;

        public MyComponent(InitParams params) {
            this.params = params;
        }

        public String getValue(String name) {
            ValueParam vp = this.params.getValueParam(name);
            return vp == null ? null : vp.getValue();
        }
    }
}

