/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ExoEnumeration;
import org.exoplatform.container.util.ContainerUtil;

public class TestContainerUtil
extends TestCase {
    private ClassLoader oldCLoader;

    protected void setUp() throws Exception {
        super.setUp();
        this.oldCLoader = Thread.currentThread().getContextClassLoader();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Thread.currentThread().setContextClassLoader(this.oldCLoader);
    }

    public void testGetServletContextName() {
        final AtomicReference<String> scn = new AtomicReference<String>("myContextName");
        final AtomicReference<String> scp = new AtomicReference<String>("/myContextPath");
        ServletContext context = (ServletContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getServletContextName".equals(method.getName())) {
                    return scn.get();
                }
                if ("getContextPath".equals(method.getName())) {
                    return scp.get();
                }
                return null;
            }
        });
        TestContainerUtil.assertEquals((String)"myContextName", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scn.set(null);
        TestContainerUtil.assertEquals((String)"myContextPath", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("");
        TestContainerUtil.assertEquals((String)"", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("/a/b");
        TestContainerUtil.assertEquals((String)"a", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("/a2/b/");
        TestContainerUtil.assertEquals((String)"a2", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("a3/b");
        TestContainerUtil.assertEquals((String)"a3", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set("a4/b/");
        TestContainerUtil.assertEquals((String)"a4", (String)ContainerUtil.getServletContextName((ServletContext)context));
        scp.set(null);
        TestContainerUtil.assertNull((Object)ContainerUtil.getServletContextName((ServletContext)context));
    }

    public void testURLsKeepInsertionOrderWhenGettingConfigurationURLs() throws Exception {
        Thread.currentThread().setContextClassLoader(new MockClassLoader());
        Collection urls = ContainerUtil.getConfigurationURL((String)"dummy");
        TestContainerUtil.assertNotNull((Object)urls);
        Iterator urlIterator = urls.iterator();
        TestContainerUtil.assertEquals((String)"file:/url1", (String)((URL)urlIterator.next()).toString());
        TestContainerUtil.assertEquals((String)"file:/url2", (String)((URL)urlIterator.next()).toString());
        TestContainerUtil.assertEquals((String)"file:/url3", (String)((URL)urlIterator.next()).toString());
    }

    private static class MockClassLoader
    extends ClassLoader {
        private MockClassLoader() {
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            List<URL> resources = Arrays.asList(new URL("file:/url1"), new URL("file:/url2"), new URL("file:/url3"));
            return new ExoEnumeration(resources.iterator());
        }
    }
}

