/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.lang.management.ManagementFactory;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.monitor.jvm.MemoryInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddJVMComponentsToRootContainer
extends BaseContainerLifecyclePlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.AddJVMComponentsToRootContainer");

    @Override
    public void initContainer(ExoContainer container) {
        this.attemptToRegisterMXComponent(container, ManagementFactory.getOperatingSystemMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getRuntimeMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getThreadMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getClassLoadingMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getCompilationMXBean());
        this.attemptToRegisterMXComponent(container, new MemoryInfo());
        this.attemptToRegisterMXComponent(container, "MemoryManagerMXBean", ManagementFactory.getMemoryManagerMXBeans());
        this.attemptToRegisterMXComponent(container, "MemoryPoolMXBeans", ManagementFactory.getMemoryPoolMXBeans());
        this.attemptToRegisterMXComponent(container, "GarbageCollectorMXBeans", ManagementFactory.getGarbageCollectorMXBeans());
    }

    private void attemptToRegisterMXComponent(ExoContainer container, Object mxComponent) {
        if (mxComponent != null) {
            LOG.debug((Object)("Attempt to register mx component " + String.valueOf(mxComponent)));
            container.registerComponentInstance(mxComponent);
            LOG.debug((Object)("Mx component " + String.valueOf(mxComponent) + " registered"));
        }
    }

    private void attemptToRegisterMXComponent(ExoContainer container, Object mxKey, Object mxComponent) {
        if (mxComponent != null) {
            LOG.debug((Object)("Attempt to register mx component " + String.valueOf(mxComponent) + " with key " + String.valueOf(mxKey)));
            container.registerComponentInstance(mxKey, mxComponent);
            LOG.debug((Object)("Mx component " + String.valueOf(mxComponent) + " registered"));
        }
    }
}

